/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import org.cryptomator.cryptofs.UnsupportedFileAttributeViewException;

class CryptoFileOwnerAttributeView
implements FileOwnerAttributeView {
    private final FileOwnerAttributeView delegate;

    public CryptoFileOwnerAttributeView(Path path) throws UnsupportedFileAttributeViewException {
        this.delegate = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
        if (this.delegate == null) {
            throw new UnsupportedFileAttributeViewException();
        }
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.delegate.getOwner();
    }

    @Override
    public void setOwner(UserPrincipal userPrincipal) throws IOException {
        this.delegate.setOwner(userPrincipal);
    }

    @Override
    public String name() {
        return "owner";
    }
}

