/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class CryptoFileLock
extends FileLock {
    private final FileLock delegate;

    private CryptoFileLock(Builder builder) {
        super(builder.channel, (long)builder.position, (long)builder.size, (boolean)builder.shared);
        this.delegate = builder.delegate;
    }

    FileLock delegate() {
        return this.delegate;
    }

    @Override
    public boolean isValid() {
        FileChannel fileChannel = this.channel();
        assert (fileChannel != null) : "final field initialized with non-null value in super constructor";
        return this.delegate.isValid() && fileChannel.isOpen();
    }

    @Override
    public void release() throws IOException {
        this.delegate.release();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FileLock delegate;
        private FileChannel channel;
        private Long position;
        private Long size;
        private Boolean shared;

        private Builder() {
        }

        public Builder withDelegate(FileLock fileLock) {
            this.delegate = fileLock;
            return this;
        }

        public Builder withChannel(FileChannel fileChannel) {
            this.channel = fileChannel;
            return this;
        }

        public Builder withPosition(long l) {
            this.position = l;
            return this;
        }

        public Builder withSize(long l) {
            this.size = l;
            return this;
        }

        public Builder thatIsShared(boolean bl) {
            this.shared = bl;
            return this;
        }

        public CryptoFileLock build() {
            this.validate();
            return new CryptoFileLock(this);
        }

        private void validate() {
            this.assertNonNull(this.delegate, "delegate");
            this.assertNonNull(this.channel, "channel");
            this.assertNonNull(this.position, "position");
            this.assertNonNull(this.size, "size");
            this.assertNonNull(this.shared, "shared");
        }

        private void assertNonNull(Object object, String string) {
            if (object == null) {
                throw new IllegalStateException(string + " must be set");
            }
        }
    }
}

