/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoBasicFileAttributes;
import org.cryptomator.cryptofs.CryptoDosFileAttributes;
import org.cryptomator.cryptofs.CryptoPosixFileAttributes;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptolib.api.Cryptor;

@PerFileSystem
class CryptoFileAttributeProvider {
    private final Map<Class<? extends BasicFileAttributes>, AttributeProvider<? extends BasicFileAttributes>> attributeProviders = new HashMap<Class<? extends BasicFileAttributes>, AttributeProvider<? extends BasicFileAttributes>>();
    private final Cryptor cryptor;

    @Inject
    public CryptoFileAttributeProvider(Cryptor cryptor) {
        this.attributeProviders.put(BasicFileAttributes.class, CryptoBasicFileAttributes::new);
        this.attributeProviders.put(PosixFileAttributes.class, CryptoPosixFileAttributes::new);
        this.attributeProviders.put(DosFileAttributes.class, CryptoDosFileAttributes::new);
        this.cryptor = cryptor;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz) throws IOException {
        if (this.attributeProviders.containsKey(clazz)) {
            A a = Files.readAttributes(path, clazz, new LinkOption[0]);
            AttributeProvider<? extends BasicFileAttributes> attributeProvider = this.attributeProviders.get(clazz);
            return (A)attributeProvider.provide((BasicFileAttributes)a, path, this.cryptor);
        }
        throw new UnsupportedOperationException("Unsupported file attribute type: " + clazz);
    }

    @FunctionalInterface
    private static interface AttributeProvider<A extends BasicFileAttributes> {
        public A provide(A var1, Path var2, Cryptor var3);
    }
}

