/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cryptomator.cryptofs.ConflictResolver;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.FinallyUtil;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileNameCryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CryptoDirectoryStream
implements DirectoryStream<Path> {
    private static final Pattern BASE32_PATTERN = Pattern.compile("^0?(([A-Z2-7]{8})*[A-Z2-7=]{8})");
    private static final Logger LOG = LoggerFactory.getLogger(CryptoDirectoryStream.class);
    private final String directoryId;
    private final DirectoryStream<Path> ciphertextDirStream;
    private final Path cleartextDir;
    private final FileNameCryptor filenameCryptor;
    private final CryptoPathMapper cryptoPathMapper;
    private final LongFileNameProvider longFileNameProvider;
    private final ConflictResolver conflictResolver;
    private final DirectoryStream.Filter<? super Path> filter;
    private final Consumer<CryptoDirectoryStream> onClose;
    private final FinallyUtil finallyUtil;

    public CryptoDirectoryStream(CryptoPathMapper.Directory directory, Path path2, FileNameCryptor fileNameCryptor, CryptoPathMapper cryptoPathMapper, LongFileNameProvider longFileNameProvider, ConflictResolver conflictResolver, DirectoryStream.Filter<? super Path> filter, Consumer<CryptoDirectoryStream> consumer, FinallyUtil finallyUtil) throws IOException {
        this.onClose = consumer;
        this.finallyUtil = finallyUtil;
        this.directoryId = directory.dirId;
        this.ciphertextDirStream = Files.newDirectoryStream(directory.path, path -> true);
        LOG.trace("OPEN {}", (Object)this.directoryId);
        this.cleartextDir = path2;
        this.filenameCryptor = fileNameCryptor;
        this.cryptoPathMapper = cryptoPathMapper;
        this.longFileNameProvider = longFileNameProvider;
        this.conflictResolver = conflictResolver;
        this.filter = filter;
    }

    @Override
    public Iterator<Path> iterator() {
        Stream<Path> stream = StreamSupport.stream(this.ciphertextDirStream.spliterator(), false);
        Stream<Path> stream2 = stream.map(this::resolveConflictingFileIfNeeded).filter(Objects::nonNull);
        Stream<Path> stream3 = stream2.filter(this::passesPlausibilityChecks);
        Stream<Path> stream4 = stream3.map(this::inflateIfNeeded).filter(Objects::nonNull);
        Stream<Path> stream5 = stream4.map(this::decrypt).filter(Objects::nonNull);
        Stream<Path> stream6 = stream5.filter(this::isAcceptableByFilter);
        return stream6.iterator();
    }

    private Path resolveConflictingFileIfNeeded(Path path) {
        try {
            return this.conflictResolver.resolveConflictsIfNecessary(path, this.directoryId);
        }
        catch (IOException iOException) {
            LOG.warn("I/O exception while finding potentially conflicting file versions for {}.", (Object)path);
            return null;
        }
    }

    private Path inflateIfNeeded(Path path) {
        String string = path.getFileName().toString();
        if (LongFileNameProvider.isDeflated(string)) {
            try {
                String string2 = this.longFileNameProvider.inflate(string);
                return path.resolveSibling(string2);
            }
            catch (IOException iOException) {
                LOG.warn(path + " could not be inflated.");
                return null;
            }
        }
        return path;
    }

    private boolean passesPlausibilityChecks(Path path) {
        return !this.isBrokenDirectoryFile(path);
    }

    private boolean isBrokenDirectoryFile(Path path) {
        if (path.getFileName().toString().startsWith("0")) {
            Path path2;
            try {
                path2 = this.cryptoPathMapper.resolveDirectory((Path)path).path;
            }
            catch (IOException iOException) {
                LOG.warn("Broken directory file {}. Exception: {}", (Object)path, (Object)iOException.getMessage());
                return true;
            }
            if (!Files.isDirectory(path2, new LinkOption[0])) {
                LOG.warn("Broken directory file {}. Directory {} does not exist.", (Object)path, (Object)path2);
                return true;
            }
        }
        return false;
    }

    private Path decrypt(Path path) {
        String string = path.getFileName().toString();
        Matcher matcher = BASE32_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                String string3 = this.filenameCryptor.decryptFilename(string2, new byte[][]{this.directoryId.getBytes(StandardCharsets.UTF_8)});
                return this.cleartextDir.resolve(string3);
            }
            catch (AuthenticationFailedException authenticationFailedException) {
                LOG.warn(path + " not decryptable due to an unauthentic ciphertext.");
                return null;
            }
        }
        return null;
    }

    private boolean isAcceptableByFilter(Path path) {
        try {
            return this.filter.accept(path);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        this.finallyUtil.guaranteeInvocationOf(() -> this.ciphertextDirStream.close(), () -> this.onClose.accept(this), () -> LOG.trace("CLOSE {}", (Object)this.directoryId));
    }
}

