/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.StringUtils;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerFileSystem
class ConflictResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ConflictResolver.class);
    private static final Pattern BASE32_PATTERN = Pattern.compile("0?(([A-Z2-7]{8})*[A-Z2-7=]{8})");
    private static final int MAX_DIR_FILE_SIZE = 87;
    private final LongFileNameProvider longFileNameProvider;
    private final Cryptor cryptor;

    @Inject
    public ConflictResolver(LongFileNameProvider longFileNameProvider, Cryptor cryptor) {
        this.longFileNameProvider = longFileNameProvider;
        this.cryptor = cryptor;
    }

    public Path resolveConflictsIfNecessary(Path path, String string) throws IOException {
        String string2 = path.getFileName().toString();
        String string3 = StringUtils.removeEnd(string2, ".lng");
        Matcher matcher = BASE32_PATTERN.matcher(string3);
        if (!matcher.matches() && matcher.find(0)) {
            return this.resolveConflict(path, matcher.group(1), string);
        }
        return path;
    }

    private Path resolveConflict(Path path, String string, String string2) throws IOException {
        Path path2;
        String string3;
        boolean bl;
        String string4;
        Path path3 = path.getParent();
        String string5 = path.getFileName().toString();
        if (LongFileNameProvider.isDeflated(string5)) {
            String string6 = this.longFileNameProvider.inflate(string + ".lng");
            string4 = StringUtils.removeStart(string6, "0");
            bl = string6.startsWith("0");
            string3 = bl ? "0" : "";
            path2 = path3.resolve(string + ".lng");
        } else {
            string4 = string;
            bl = string5.startsWith("0");
            string3 = bl ? "0" : "";
            path2 = path3.resolve(string3 + string4);
        }
        if (bl && this.resolveDirectoryConflictTrivially(path2, path)) {
            return path2;
        }
        return this.renameConflictingFile(path2, path, string4, string2, string3);
    }

    private Path renameConflictingFile(Path path, Path path2, String string, String string2, String string3) throws IOException {
        try {
            String string4 = this.cryptor.fileNameCryptor().decryptFilename(string, new byte[][]{string2.getBytes(StandardCharsets.UTF_8)});
            Path path3 = path;
            int n = 1;
            while (Files.exists(path3, new LinkOption[0])) {
                String string5 = string4 + " (Conflict " + n + ")";
                String string6 = this.cryptor.fileNameCryptor().encryptFilename(string5, new byte[][]{string2.getBytes(StandardCharsets.UTF_8)});
                String string7 = string3 + string6;
                if (string7.length() >= 129) {
                    string7 = this.longFileNameProvider.deflate(string7);
                }
                path3 = path.resolveSibling(string7);
                ++n;
            }
            LOG.info("Moving conflicting file {} to {}", (Object)path2, (Object)path3);
            return Files.move(path2, path3, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            LOG.info("Found valid Base32 string, which is an unauthentic ciphertext: {}", (Object)path2);
            return path2;
        }
    }

    private boolean resolveDirectoryConflictTrivially(Path path, Path path2) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.move(path2, path, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        if (this.hasSameDirFileContent(path2, path)) {
            LOG.info("Removing conflicting directory file {} (identical to {})", (Object)path2, (Object)path);
            Files.deleteIfExists(path2);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean hasSameDirFileContent(Path var1_1, Path var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

