/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.ByteBuffer;

interface ByteSource {
    public static ByteSource from(ByteBuffer byteBuffer) {
        return new ByteBufferByteSource(byteBuffer);
    }

    public static ZeroPrefixedByteSourceWithoutBuffer repeatingZeroes(long l) {
        return byteBuffer -> new ZeroPrefixedByteSource(l, byteBuffer);
    }

    public boolean hasRemaining();

    public long remaining();

    public void copyTo(ByteBuffer var1);

    public static class ZeroPrefixedByteSource
    implements ByteSource {
        private long amountOfZeroes;
        private final ByteBuffer source;

        private ZeroPrefixedByteSource(long l, ByteBuffer byteBuffer) {
            this.amountOfZeroes = l;
            this.source = byteBuffer;
        }

        @Override
        public boolean hasRemaining() {
            return this.amountOfZeroes > 0L || this.source.hasRemaining();
        }

        @Override
        public long remaining() {
            return this.amountOfZeroes + (long)this.source.remaining();
        }

        @Override
        public void copyTo(ByteBuffer byteBuffer) {
            if (this.amountOfZeroes > 0L) {
                this.copyZeroesTo(byteBuffer);
            }
            if (byteBuffer.hasRemaining()) {
                this.copySourceTo(byteBuffer);
            }
        }

        private void copyZeroesTo(ByteBuffer byteBuffer) {
            int n = (int)Math.min(this.amountOfZeroes, Integer.MAX_VALUE);
            int n2 = Math.min(n, byteBuffer.remaining());
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
            byteBuffer.put(byteBuffer2);
            this.amountOfZeroes -= (long)n2;
        }

        private void copySourceTo(ByteBuffer byteBuffer) {
            int n = this.source.limit();
            int n2 = Math.min(this.source.limit(), this.source.position() + byteBuffer.remaining());
            this.source.limit(n2);
            byteBuffer.put(this.source);
            this.source.limit(n);
        }
    }

    public static class ByteBufferByteSource
    implements ByteSource {
        private final ByteBuffer source;

        private ByteBufferByteSource(ByteBuffer byteBuffer) {
            this.source = byteBuffer;
        }

        @Override
        public boolean hasRemaining() {
            return this.source.hasRemaining();
        }

        @Override
        public long remaining() {
            return this.source.remaining();
        }

        @Override
        public void copyTo(ByteBuffer byteBuffer) {
            if (this.source.remaining() > byteBuffer.remaining()) {
                int n = this.source.limit();
                this.source.limit(this.source.position() + byteBuffer.remaining());
                byteBuffer.put(this.source);
                this.source.limit(n);
            } else {
                byteBuffer.put(this.source);
            }
        }
    }

    public static interface ZeroPrefixedByteSourceWithoutBuffer {
        public ByteSource followedBy(ByteBuffer var1);
    }
}

