/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class AsyncDelegatingFileChannel
extends AsynchronousFileChannel {
    private final FileChannel channel;
    private final ExecutorService executor;

    public AsyncDelegatingFileChannel(FileChannel fileChannel, ExecutorService executorService) {
        this.channel = fileChannel;
        this.executor = executorService;
    }

    @Deprecated
    FileChannel getChannel() {
        return this.channel;
    }

    @Deprecated
    ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public AsynchronousFileChannel truncate(long l) throws IOException {
        this.channel.truncate(l);
        return this;
    }

    @Override
    public void force(boolean bl) throws IOException {
        this.channel.force(bl);
    }

    @Override
    public <A> void lock(long l, long l2, boolean bl, A a, CompletionHandler<FileLock, ? super A> completionHandler) {
        this.executor.submit(new CompletionHandlerInvoker<FileLock, A>(this.lock(l, l2, bl), completionHandler, a));
    }

    @Override
    public Future<FileLock> lock(long l, long l2, boolean bl) {
        if (!this.isOpen()) {
            return this.exceptionalFuture(new ClosedChannelException());
        }
        return this.executor.submit(() -> this.channel.lock(l, l2, bl));
    }

    @Override
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.channel.tryLock(l, l2, bl);
    }

    @Override
    public <A> void read(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.executor.submit(new CompletionHandlerInvoker<Integer, A>(this.read(byteBuffer, l), completionHandler, a));
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer, long l) {
        if (!this.isOpen()) {
            return this.exceptionalFuture(new ClosedChannelException());
        }
        return this.executor.submit(() -> this.channel.read(byteBuffer, l));
    }

    @Override
    public <A> void write(ByteBuffer byteBuffer, long l, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        this.executor.submit(new CompletionHandlerInvoker<Integer, A>(this.write(byteBuffer, l), completionHandler, a));
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer, long l) {
        if (!this.isOpen()) {
            return this.exceptionalFuture(new ClosedChannelException());
        }
        return this.executor.submit(() -> this.channel.write(byteBuffer, l));
    }

    private <T> Future<T> exceptionalFuture(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    private static class CompletionHandlerInvoker<T, A>
    implements Runnable {
        private final Future<T> future;
        private final CompletionHandler<T, ? super A> completionHandler;
        private final A attachment;

        public CompletionHandlerInvoker(Future<T> future, CompletionHandler<T, ? super A> completionHandler, A a) {
            this.future = Objects.requireNonNull(future);
            this.completionHandler = Objects.requireNonNull(completionHandler);
            this.attachment = a;
        }

        @Override
        public void run() {
            try {
                T t = this.future.get();
                this.completionHandler.completed(t, this.attachment);
            }
            catch (ExecutionException executionException) {
                this.completionHandler.failed(executionException.getCause(), this.attachment);
            }
            catch (InterruptedException | CancellationException exception) {
                this.completionHandler.failed(exception, this.attachment);
            }
        }
    }
}

