/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.utils.DateUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class ResponseCachingPolicy {
    private static final String[] AUTH_CACHEABLE_PARAMS = new String[]{"s-maxage", "must-revalidate", "public"};
    private final long maxObjectSizeBytes;
    private final boolean sharedCache;
    private final boolean neverCache1_0ResponsesWithQueryString;
    private final Log log = LogFactory.getLog(this.getClass());
    private static final Set<Integer> cacheableStatuses = new HashSet<Integer>(Arrays.asList(200, 203, 300, 301, 410));
    private final Set<Integer> uncacheableStatuses;

    public ResponseCachingPolicy(long l, boolean bl, boolean bl2, boolean bl3) {
        this.maxObjectSizeBytes = l;
        this.sharedCache = bl;
        this.neverCache1_0ResponsesWithQueryString = bl2;
        this.uncacheableStatuses = bl3 ? new HashSet<Integer>(Arrays.asList(206)) : new HashSet<Integer>(Arrays.asList(206, 303));
    }

    public boolean isResponseCacheable(String string, HttpResponse httpResponse) {
        int n;
        boolean bl = false;
        if (!"GET".equals(string) && !"HEAD".equals(string)) {
            this.log.debug("Response was not cacheable.");
            return false;
        }
        int n2 = httpResponse.getStatusLine().getStatusCode();
        if (cacheableStatuses.contains(n2)) {
            bl = true;
        } else {
            if (this.uncacheableStatuses.contains(n2)) {
                return false;
            }
            if (this.unknownStatusCode(n2)) {
                return false;
            }
        }
        Header header = httpResponse.getFirstHeader("Content-Length");
        if (header != null && (long)(n = Integer.parseInt(header.getValue())) > this.maxObjectSizeBytes) {
            return false;
        }
        Header[] headerArray = httpResponse.getHeaders("Age");
        if (headerArray.length > 1) {
            return false;
        }
        Header[] headerArray2 = httpResponse.getHeaders("Expires");
        if (headerArray2.length > 1) {
            return false;
        }
        Header[] headerArray3 = httpResponse.getHeaders("Date");
        if (headerArray3.length != 1) {
            return false;
        }
        Date date = DateUtils.parseDate(headerArray3[0].getValue());
        if (date == null) {
            return false;
        }
        for (Header header2 : httpResponse.getHeaders("Vary")) {
            for (HeaderElement headerElement : header2.getElements()) {
                if (!"*".equals(headerElement.getName())) continue;
                return false;
            }
        }
        if (this.isExplicitlyNonCacheable(httpResponse)) {
            return false;
        }
        return bl || this.isExplicitlyCacheable(httpResponse);
    }

    private boolean unknownStatusCode(int n) {
        if (n >= 100 && n <= 101) {
            return false;
        }
        if (n >= 200 && n <= 206) {
            return false;
        }
        if (n >= 300 && n <= 307) {
            return false;
        }
        if (n >= 400 && n <= 417) {
            return false;
        }
        return n < 500 || n > 505;
    }

    protected boolean isExplicitlyNonCacheable(HttpResponse httpResponse) {
        Header[] headerArray;
        for (Header header : headerArray = httpResponse.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"no-store".equals(headerElement.getName()) && !"no-cache".equals(headerElement.getName()) && (!this.sharedCache || !"private".equals(headerElement.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasCacheControlParameterFrom(HttpMessage httpMessage, String[] stringArray) {
        Header[] headerArray;
        for (Header header : headerArray = httpMessage.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                for (String string : stringArray) {
                    if (!string.equalsIgnoreCase(headerElement.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isExplicitlyCacheable(HttpResponse httpResponse) {
        if (httpResponse.getFirstHeader("Expires") != null) {
            return true;
        }
        String[] stringArray = new String[]{"max-age", "s-maxage", "must-revalidate", "proxy-revalidate", "public"};
        return this.hasCacheControlParameterFrom(httpResponse, stringArray);
    }

    public boolean isResponseCacheable(HttpRequest httpRequest, HttpResponse httpResponse) {
        Object object;
        if (this.requestProtocolGreaterThanAccepted(httpRequest)) {
            this.log.debug("Response was not cacheable.");
            return false;
        }
        String[] stringArray = new String[]{"no-store"};
        if (this.hasCacheControlParameterFrom(httpRequest, stringArray)) {
            return false;
        }
        if (httpRequest.getRequestLine().getUri().contains("?")) {
            if (this.neverCache1_0ResponsesWithQueryString && this.from1_0Origin(httpResponse)) {
                this.log.debug("Response was not cacheable as it had a query string.");
                return false;
            }
            if (!this.isExplicitlyCacheable(httpResponse)) {
                this.log.debug("Response was not cacheable as it is missing explicit caching headers.");
                return false;
            }
        }
        if (this.expiresHeaderLessOrEqualToDateHeaderAndNoCacheControl(httpResponse)) {
            return false;
        }
        if (this.sharedCache && (object = httpRequest.getHeaders("Authorization")) != null && ((Header[])object).length > 0 && !this.hasCacheControlParameterFrom(httpResponse, AUTH_CACHEABLE_PARAMS)) {
            return false;
        }
        object = httpRequest.getRequestLine().getMethod();
        return this.isResponseCacheable((String)object, httpResponse);
    }

    private boolean expiresHeaderLessOrEqualToDateHeaderAndNoCacheControl(HttpResponse httpResponse) {
        if (httpResponse.getFirstHeader("Cache-Control") != null) {
            return false;
        }
        Header header = httpResponse.getFirstHeader("Expires");
        Header header2 = httpResponse.getFirstHeader("Date");
        if (header == null || header2 == null) {
            return false;
        }
        Date date = DateUtils.parseDate(header.getValue());
        Date date2 = DateUtils.parseDate(header2.getValue());
        if (date == null || date2 == null) {
            return false;
        }
        return date.equals(date2) || date.before(date2);
    }

    private boolean from1_0Origin(HttpResponse httpResponse) {
        HeaderElement[] headerElementArray;
        int n;
        int n2;
        Header header = httpResponse.getFirstHeader("Via");
        if (header != null && (n2 = 0) < (n = (headerElementArray = header.getElements()).length)) {
            HeaderElement headerElement = headerElementArray[n2];
            String string = headerElement.toString().split("\\s")[0];
            if (string.contains("/")) {
                return string.equals("HTTP/1.0");
            }
            return string.equals("1.0");
        }
        return HttpVersion.HTTP_1_0.equals(httpResponse.getProtocolVersion());
    }

    private boolean requestProtocolGreaterThanAccepted(HttpRequest httpRequest) {
        return httpRequest.getProtocolVersion().compareToVersion(HttpVersion.HTTP_1_1) > 0;
    }
}

