/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.InputLimit;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.BasicIdGenerator;
import org.apache.http.impl.client.cache.FileResource;
import org.apache.http.impl.client.cache.IOUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class FileResourceFactory
implements ResourceFactory {
    private final File cacheDir;
    private final BasicIdGenerator idgen;

    public FileResourceFactory(File file) {
        this.cacheDir = file;
        this.idgen = new BasicIdGenerator();
    }

    private File generateUniqueCacheFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.idgen.generate(stringBuilder);
        stringBuilder.append('.');
        int n = Math.min(string.length(), 100);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('-');
        }
        return new File(this.cacheDir, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource generate(String string, InputStream inputStream, InputLimit inputLimit) throws IOException {
        File file = this.generateUniqueCacheFile(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            byte[] byArray = new byte[2048];
            long l = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                if (inputLimit == null || (l += (long)n) <= inputLimit.getValue()) continue;
                inputLimit.reached();
                break;
            }
        }
        finally {
            fileOutputStream.close();
        }
        return new FileResource(file);
    }

    @Override
    public Resource copy(String string, Resource resource) throws IOException {
        File file = this.generateUniqueCacheFile(string);
        if (resource instanceof FileResource) {
            File file2 = ((FileResource)resource).getFile();
            IOUtils.copyFile(file2, file);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IOUtils.copyAndClose(resource.getInputStream(), fileOutputStream);
        }
        return new FileResource(file);
    }
}

