/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.impl.client.cache.FailureCache;
import org.apache.http.impl.client.cache.FailureCacheValue;

@Contract(threading=ThreadingBehavior.SAFE)
public class DefaultFailureCache
implements FailureCache {
    static final int DEFAULT_MAX_SIZE = 1000;
    static final int MAX_UPDATE_TRIES = 10;
    private final int maxSize;
    private final ConcurrentMap<String, FailureCacheValue> storage;

    public DefaultFailureCache() {
        this(1000);
    }

    public DefaultFailureCache(int n) {
        this.maxSize = n;
        this.storage = new ConcurrentHashMap<String, FailureCacheValue>();
    }

    @Override
    public int getErrorCount(String string) {
        if (string == null) {
            throw new IllegalArgumentException("identifier may not be null");
        }
        FailureCacheValue failureCacheValue = (FailureCacheValue)this.storage.get(string);
        return failureCacheValue != null ? failureCacheValue.getErrorCount() : 0;
    }

    @Override
    public void resetErrorCount(String string) {
        if (string == null) {
            throw new IllegalArgumentException("identifier may not be null");
        }
        this.storage.remove(string);
    }

    @Override
    public void increaseErrorCount(String string) {
        if (string == null) {
            throw new IllegalArgumentException("identifier may not be null");
        }
        this.updateValue(string);
        this.removeOldestEntryIfMapSizeExceeded();
    }

    private void updateValue(String string) {
        for (int i = 0; i < 10; ++i) {
            FailureCacheValue failureCacheValue = (FailureCacheValue)this.storage.get(string);
            if (failureCacheValue == null) {
                FailureCacheValue failureCacheValue2 = new FailureCacheValue(string, 1);
                if (this.storage.putIfAbsent(string, failureCacheValue2) != null) continue;
                return;
            }
            int n = failureCacheValue.getErrorCount();
            if (n == Integer.MAX_VALUE) {
                return;
            }
            FailureCacheValue failureCacheValue3 = new FailureCacheValue(string, n + 1);
            if (!this.storage.replace(string, failureCacheValue, failureCacheValue3)) continue;
            return;
        }
    }

    private void removeOldestEntryIfMapSizeExceeded() {
        FailureCacheValue failureCacheValue;
        if (this.storage.size() > this.maxSize && (failureCacheValue = this.findValueWithOldestTimestamp()) != null) {
            this.storage.remove(failureCacheValue.getKey(), failureCacheValue);
        }
    }

    private FailureCacheValue findValueWithOldestTimestamp() {
        long l = Long.MAX_VALUE;
        FailureCacheValue failureCacheValue = null;
        for (Map.Entry entry : this.storage.entrySet()) {
            FailureCacheValue failureCacheValue2 = (FailureCacheValue)entry.getValue();
            long l2 = failureCacheValue2.getCreationTimeInNanos();
            if (l2 >= l) continue;
            l = l2;
            failureCacheValue = (FailureCacheValue)entry.getValue();
        }
        return failureCacheValue;
    }
}

