/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.utils.URIUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheKeyGenerator {
    private static final URI BASE_URI = URI.create("http://example.com/");

    CacheKeyGenerator() {
    }

    public String getURI(HttpHost httpHost, HttpRequest httpRequest) {
        if (this.isRelativeRequest(httpRequest)) {
            return this.canonicalizeUri(String.format("%s%s", httpHost.toString(), httpRequest.getRequestLine().getUri()));
        }
        return this.canonicalizeUri(httpRequest.getRequestLine().getUri());
    }

    public String canonicalizeUri(String string) {
        try {
            URI uRI = URIUtils.resolve(BASE_URI, string);
            URL uRL = new URL(uRI.toASCIIString());
            String string2 = uRL.getProtocol();
            String string3 = uRL.getHost();
            int n = this.canonicalizePort(uRL.getPort(), string2);
            String string4 = uRL.getPath();
            String string5 = uRL.getQuery();
            String string6 = string5 != null ? string4 + "?" + string5 : string4;
            URL uRL2 = new URL(string2, string3, n, string6);
            return uRL2.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private int canonicalizePort(int n, String string) {
        if (n == -1 && "http".equalsIgnoreCase(string)) {
            return 80;
        }
        if (n == -1 && "https".equalsIgnoreCase(string)) {
            return 443;
        }
        return n;
    }

    private boolean isRelativeRequest(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getUri();
        return "*".equals(string) || string.startsWith("/");
    }

    protected String getFullHeaderValue(Header[] headerArray) {
        if (headerArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        boolean bl = true;
        for (Header header : headerArray) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(header.getValue().trim());
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String getVariantURI(HttpHost httpHost, HttpRequest httpRequest, HttpCacheEntry httpCacheEntry) {
        if (!httpCacheEntry.hasVariants()) {
            return this.getURI(httpHost, httpRequest);
        }
        return this.getVariantKey(httpRequest, httpCacheEntry) + this.getURI(httpHost, httpRequest);
    }

    public String getVariantKey(HttpRequest httpRequest, HttpCacheEntry httpCacheEntry) {
        StringBuilder stringBuilder;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Header object : httpCacheEntry.getHeaders("Vary")) {
            for (HeaderElement headerElement : object.getElements()) {
                arrayList.add(headerElement.getName());
            }
        }
        Collections.sort(arrayList);
        try {
            stringBuilder = new StringBuilder("{");
            int n = 1;
            for (String string : arrayList) {
                if (n == 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(URLEncoder.encode(string, Consts.UTF_8.name()));
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(this.getFullHeaderValue(httpRequest.getHeaders(string)), Consts.UTF_8.name()));
                n = 0;
            }
            stringBuilder.append("}");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("couldn't encode to UTF-8", unsupportedEncodingException);
        }
        return stringBuilder.toString();
    }
}

