/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class CountingOutputStream
extends ProxyOutputStream {
    private long count;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(byte[] byArray) throws IOException {
        this.count += (long)byArray.length;
        super.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.count += (long)n2;
        super.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        ++this.count;
        super.write(n);
    }

    public synchronized int getCount() {
        long l = this.getByteCount();
        if (l > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l + " is too large to be converted to an int");
        }
        return (int)l;
    }

    public synchronized int resetCount() {
        long l = this.resetByteCount();
        if (l > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + l + " is too large to be converted to an int");
        }
        return (int)l;
    }

    public synchronized long getByteCount() {
        return this.count;
    }

    public synchronized long resetByteCount() {
        long l = this.count;
        this.count = 0L;
        return l;
    }
}

