/*
 * Decompiled with CFR 0.152.
 */
package net.contentobjects.jnotify.linux;

import de.dal33t.powerfolder.util.os.OSUtil;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.linux.INotifyListener;
import net.contentobjects.jnotify.linux.JNotifyException_linux;

public class JNotify_linux {
    static final boolean DEBUG = false;
    public static boolean WARN = true;
    public static final int IN_ACCESS = 1;
    public static final int IN_MODIFY = 2;
    public static final int IN_ATTRIB = 4;
    public static final int IN_CLOSE_WRITE = 8;
    public static final int IN_CLOSE_NOWRITE = 16;
    public static final int IN_OPEN = 32;
    public static final int IN_MOVED_FROM = 64;
    public static final int IN_MOVED_TO = 128;
    public static final int IN_CREATE = 256;
    public static final int IN_DELETE = 512;
    public static final int IN_DELETE_SELF = 1024;
    public static final int IN_MOVE_SELF = 2048;
    public static final int IN_UNMOUNT = 8192;
    public static final int IN_Q_OVERFLOW = 16384;
    public static final int IN_IGNORED = 32768;
    public static final int IN_CLOSE = 24;
    public static final int IN_MOVE = 192;
    public static final int IN_ISDIR = 0x40000000;
    public static final int IN_ONESHOT = Integer.MIN_VALUE;
    public static final int IN_ALL_EVENT = 2047;
    private static INotifyListener _notifyListener;

    private static native int nativeInit();

    private static native int nativeAddWatch(String var0, int var1);

    private static native int nativeRemoveWatch(int var0);

    private static native int nativeNotifyLoop();

    private static native String getErrorDesc(long var0);

    public static int addWatch(String string, int n) throws JNotifyException {
        int n2 = JNotify_linux.nativeAddWatch(string, n);
        if (n2 < 0) {
            throw new JNotifyException_linux("Error watching " + string + " : " + JNotify_linux.getErrorDesc(-n2), -n2);
        }
        JNotify_linux.debug(n2 + " = JNotify_linux.addWatch(" + string + "," + JNotify_linux.getMaskDesc(n) + ")");
        return n2;
    }

    public static void removeWatch(int n) throws JNotifyException {
        int n2 = JNotify_linux.nativeRemoveWatch(n);
        JNotify_linux.debug(n2 + " = JNotify_linux.removeWatch(" + n + ")");
        if (n2 != 0) {
            throw new JNotifyException_linux("Error removing watch " + n, n2);
        }
    }

    private static void init() {
        Thread thread = new Thread("INotify thread"){

            @Override
            public void run() {
                JNotify_linux.nativeNotifyLoop();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    static void callbackProcessEvent(String string, int n, int n2, int n3) {
        JNotify_linux.debug("JNotify.event(name=" + string + ", wd=" + n + ", " + JNotify_linux.getMaskDesc(n2) + (String)(n3 != 0 ? ", cookie=" + n3 : "") + ")");
        if (_notifyListener != null) {
            _notifyListener.notify(string, n, n2, n3);
        }
    }

    public static void setNotifyListener(INotifyListener iNotifyListener) {
        if (_notifyListener != null) {
            throw new RuntimeException("Notify listener is already set. multiple notify listeners are not supported.");
        }
        _notifyListener = iNotifyListener;
    }

    private static String getMaskDesc(int n) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = (n & 8) != 0;
        boolean bl5 = (n & 0x10) != 0;
        boolean bl6 = (n & 0x20) != 0;
        boolean bl7 = (n & 0x40) != 0;
        boolean bl8 = (n & 0x80) != 0;
        boolean bl9 = (n & 0x100) != 0;
        boolean bl10 = (n & 0x200) != 0;
        boolean bl11 = (n & 0x400) != 0;
        boolean bl12 = (n & 0x800) != 0;
        boolean bl13 = (n & 0x2000) != 0;
        boolean bl14 = (n & 0x4000) != 0;
        boolean bl15 = (n & 0x8000) != 0;
        Object object = "";
        if (bl) {
            object = (String)object + "IN_ACCESS|";
        }
        if (bl2) {
            object = (String)object + "IN_MODIFY|";
        }
        if (bl3) {
            object = (String)object + "IN_ATTRIB|";
        }
        if (bl4) {
            object = (String)object + "IN_CLOSE_WRITE|";
        }
        if (bl5) {
            object = (String)object + "IN_CLOSE_NOWRITE|";
        }
        if (bl6) {
            object = (String)object + "IN_OPEN|";
        }
        if (bl7) {
            object = (String)object + "IN_MOVED_FROM|";
        }
        if (bl8) {
            object = (String)object + "IN_MOVED_TO|";
        }
        if (bl9) {
            object = (String)object + "IN_CREATE|";
        }
        if (bl10) {
            object = (String)object + "IN_DELETE|";
        }
        if (bl11) {
            object = (String)object + "IN_DELETE_SELF|";
        }
        if (bl12) {
            object = (String)object + "IN_MOVE_SELF|";
        }
        if (bl13) {
            object = (String)object + "IN_UNMOUNT|";
        }
        if (bl14) {
            object = (String)object + "IN_Q_OVERFLOW|";
        }
        if (bl15) {
            object = (String)object + "IN_IGNORED|";
        }
        return object;
    }

    static void debug(String string) {
    }

    public static void warn(String string) {
        if (WARN) {
            System.err.println(string);
        }
    }

    static {
        OSUtil.loadLibrary(JNotify_linux.class, "jnotify");
        int n = JNotify_linux.nativeInit();
        if (n != 0) {
            throw new RuntimeException("Error initializing fshook_inotify library. linux error code #" + n + ", man errno for more info");
        }
        JNotify_linux.init();
    }
}

