/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

abstract class DnsNameResolverContext<T> {
    private static final int INADDRSZ4 = 4;
    private static final int INADDRSZ6 = 16;
    private static final FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>> RELEASE_RESPONSE = new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

        @Override
        public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
            if (future.isSuccess()) {
                future.getNow().release();
            }
        }
    };
    private final DnsNameResolver parent;
    private final DnsServerAddressStream nameServerAddrs;
    private final String hostname;
    private final DnsCache resolveCache;
    private final boolean traceEnabled;
    private final int maxAllowedQueries;
    private final InternetProtocolFamily[] resolveAddressTypes;
    private final Set<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> queriesInProgress = Collections.newSetFromMap(new IdentityHashMap());
    private List<DnsCacheEntry> resolvedEntries;
    private StringBuilder trace;
    private int allowedQueries;
    private boolean triedCNAME;

    protected DnsNameResolverContext(DnsNameResolver dnsNameResolver, String string, DnsCache dnsCache) {
        this.parent = dnsNameResolver;
        this.hostname = string;
        this.resolveCache = dnsCache;
        this.nameServerAddrs = dnsNameResolver.nameServerAddresses.stream();
        this.maxAllowedQueries = dnsNameResolver.maxQueriesPerResolve();
        this.resolveAddressTypes = dnsNameResolver.resolveAddressTypesUnsafe();
        this.traceEnabled = dnsNameResolver.isTraceEnabled();
        this.allowedQueries = this.maxAllowedQueries;
    }

    void resolve(Promise<T> promise) {
        boolean bl;
        boolean bl2 = bl = this.parent.searchDomains().length == 0 || StringUtil.endsWith(this.hostname, '.');
        if (bl) {
            this.internalResolve(promise);
        } else {
            final Promise<T> promise2 = promise;
            promise = this.parent.executor().newPromise();
            promise.addListener(new FutureListener<T>(){
                int count;

                @Override
                public void operationComplete(Future<T> future) throws Exception {
                    if (future.isSuccess()) {
                        promise2.trySuccess(future.getNow());
                    } else if (this.count < DnsNameResolverContext.this.parent.searchDomains().length) {
                        String string = DnsNameResolverContext.this.parent.searchDomains()[this.count++];
                        Promise promise = DnsNameResolverContext.this.parent.executor().newPromise();
                        String string2 = DnsNameResolverContext.this.hostname + "." + string;
                        DnsNameResolverContext dnsNameResolverContext = DnsNameResolverContext.this.newResolverContext(DnsNameResolverContext.this.parent, string2, DnsNameResolverContext.this.resolveCache);
                        dnsNameResolverContext.internalResolve(promise);
                        promise.addListener(this);
                    } else {
                        promise2.tryFailure(future.cause());
                    }
                }
            });
            if (this.parent.ndots() == 0) {
                this.internalResolve(promise);
            } else {
                int n = 0;
                for (int i = this.hostname.length() - 1; i >= 0; --i) {
                    if (this.hostname.charAt(i) != '.' || ++n < this.parent.ndots()) continue;
                    this.internalResolve(promise);
                    return;
                }
                promise.tryFailure(new UnknownHostException(this.hostname));
            }
        }
    }

    private void internalResolve(Promise<T> promise) {
        InetSocketAddress inetSocketAddress = this.nameServerAddrs.next();
        for (InternetProtocolFamily internetProtocolFamily : this.resolveAddressTypes) {
            DnsRecordType dnsRecordType;
            switch (internetProtocolFamily) {
                case IPv4: {
                    dnsRecordType = DnsRecordType.A;
                    break;
                }
                case IPv6: {
                    dnsRecordType = DnsRecordType.AAAA;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.query(inetSocketAddress, new DefaultDnsQuestion(this.hostname, dnsRecordType), promise);
        }
    }

    private void query(InetSocketAddress inetSocketAddress, final DnsQuestion dnsQuestion, final Promise<T> promise) {
        if (this.allowedQueries == 0 || promise.isCancelled()) {
            this.tryToFinishResolve(promise);
            return;
        }
        --this.allowedQueries;
        Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future = this.parent.query(inetSocketAddress, dnsQuestion);
        this.queriesInProgress.add(future);
        future.addListener((GenericFutureListener<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>>)new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
                DnsNameResolverContext.this.queriesInProgress.remove(future);
                if (promise.isDone() || future.isCancelled()) {
                    return;
                }
                try {
                    if (future.isSuccess()) {
                        DnsNameResolverContext.this.onResponse(dnsQuestion, future.getNow(), promise);
                    } else {
                        if (DnsNameResolverContext.this.traceEnabled) {
                            DnsNameResolverContext.this.addTrace(future.cause());
                        }
                        DnsNameResolverContext.this.query(DnsNameResolverContext.this.nameServerAddrs.next(), dnsQuestion, promise);
                    }
                }
                finally {
                    DnsNameResolverContext.this.tryToFinishResolve(promise);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResponse(DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, Promise<T> promise) {
        try {
            DnsResponse dnsResponse = addressedEnvelope.content();
            DnsResponseCode dnsResponseCode = dnsResponse.code();
            if (dnsResponseCode == DnsResponseCode.NOERROR) {
                DnsRecordType dnsRecordType = dnsQuestion.type();
                if (dnsRecordType == DnsRecordType.A || dnsRecordType == DnsRecordType.AAAA) {
                    this.onResponseAorAAAA(dnsRecordType, dnsQuestion, addressedEnvelope, promise);
                } else if (dnsRecordType == DnsRecordType.CNAME) {
                    this.onResponseCNAME(dnsQuestion, addressedEnvelope, promise);
                }
                return;
            }
            if (this.traceEnabled) {
                this.addTrace(addressedEnvelope.sender(), "response code: " + dnsResponseCode + " with " + dnsResponse.count(DnsSection.ANSWER) + " answer(s) and " + dnsResponse.count(DnsSection.AUTHORITY) + " authority resource(s)");
            }
            if (dnsResponseCode != DnsResponseCode.NXDOMAIN) {
                this.query(this.nameServerAddrs.next(), dnsQuestion, promise);
            }
        }
        finally {
            ReferenceCountUtil.safeRelease(addressedEnvelope);
        }
    }

    private void onResponseAorAAAA(DnsRecordType dnsRecordType, DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, Promise<T> promise) {
        DnsResponse dnsResponse = addressedEnvelope.content();
        Map<String, String> map = DnsNameResolverContext.buildAliasMap(dnsResponse);
        int n = dnsResponse.count(DnsSection.ANSWER);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress;
            int n2;
            Object object;
            Object t = dnsResponse.recordAt(DnsSection.ANSWER, i);
            DnsRecordType dnsRecordType2 = t.type();
            if (dnsRecordType2 != DnsRecordType.A && dnsRecordType2 != DnsRecordType.AAAA) continue;
            String string = dnsQuestion.name().toLowerCase(Locale.US);
            String string2 = t.name().toLowerCase(Locale.US);
            if (!string2.equals(string)) {
                object = string;
                while (!string2.equals(object = map.get(object)) && object != null) {
                }
                if (object == null) continue;
            }
            if (!(t instanceof DnsRawRecord) || (n2 = ((ByteBuf)(object = ((ByteBufHolder)t).content())).readableBytes()) != 4 && n2 != 16) continue;
            byte[] byArray = new byte[n2];
            ((ByteBuf)object).getBytes(((ByteBuf)object).readerIndex(), byArray);
            try {
                inetAddress = InetAddress.getByAddress(this.hostname, byArray);
            }
            catch (UnknownHostException unknownHostException) {
                throw new Error(unknownHostException);
            }
            if (this.resolvedEntries == null) {
                this.resolvedEntries = new ArrayList<DnsCacheEntry>(8);
            }
            DnsCacheEntry dnsCacheEntry = new DnsCacheEntry(this.hostname, inetAddress);
            this.resolveCache.cache(this.hostname, inetAddress, t.timeToLive(), this.parent.ch.eventLoop());
            this.resolvedEntries.add(dnsCacheEntry);
            bl = true;
        }
        if (bl) {
            return;
        }
        if (this.traceEnabled) {
            this.addTrace(addressedEnvelope.sender(), "no matching " + dnsRecordType + " record found");
        }
        if (!map.isEmpty()) {
            this.onResponseCNAME(dnsQuestion, addressedEnvelope, map, false, promise);
        }
    }

    private void onResponseCNAME(DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, Promise<T> promise) {
        this.onResponseCNAME(dnsQuestion, addressedEnvelope, DnsNameResolverContext.buildAliasMap(addressedEnvelope.content()), true, promise);
    }

    private void onResponseCNAME(DnsQuestion dnsQuestion, AddressedEnvelope<DnsResponse, InetSocketAddress> addressedEnvelope, Map<String, String> map, boolean bl, Promise<T> promise) {
        String string;
        String string2;
        String string3 = string2 = dnsQuestion.name().toLowerCase(Locale.US);
        boolean bl2 = false;
        while (!map.isEmpty() && (string = map.remove(string3)) != null) {
            bl2 = true;
            string3 = string;
        }
        if (bl2) {
            this.followCname(addressedEnvelope.sender(), string2, string3, promise);
        } else if (bl && this.traceEnabled) {
            this.addTrace(addressedEnvelope.sender(), "no matching CNAME record found");
        }
    }

    private static Map<String, String> buildAliasMap(DnsResponse dnsResponse) {
        int n = dnsResponse.count(DnsSection.ANSWER);
        Map<String, String> map = null;
        for (int i = 0; i < n; ++i) {
            ByteBuf byteBuf;
            String string;
            Object t = dnsResponse.recordAt(DnsSection.ANSWER, i);
            DnsRecordType dnsRecordType = t.type();
            if (dnsRecordType != DnsRecordType.CNAME || !(t instanceof DnsRawRecord) || (string = DnsNameResolverContext.decodeDomainName(byteBuf = ((ByteBufHolder)t).content())) == null) continue;
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(t.name().toLowerCase(Locale.US), string.toLowerCase(Locale.US));
        }
        return map != null ? map : Collections.emptyMap();
    }

    void tryToFinishResolve(Promise<T> promise) {
        if (!this.queriesInProgress.isEmpty()) {
            if (this.gotPreferredAddress()) {
                this.finishResolve(promise);
            }
            return;
        }
        if (this.resolvedEntries == null && !this.triedCNAME) {
            this.triedCNAME = true;
            this.query(this.nameServerAddrs.next(), new DefaultDnsQuestion(this.hostname, DnsRecordType.CNAME), promise);
            return;
        }
        this.finishResolve(promise);
    }

    private boolean gotPreferredAddress() {
        if (this.resolvedEntries == null) {
            return false;
        }
        int n = this.resolvedEntries.size();
        switch (this.resolveAddressTypes[0]) {
            case IPv4: {
                for (int i = 0; i < n; ++i) {
                    if (!(this.resolvedEntries.get(i).address() instanceof Inet4Address)) continue;
                    return true;
                }
                break;
            }
            case IPv6: {
                for (int i = 0; i < n; ++i) {
                    if (!(this.resolvedEntries.get(i).address() instanceof Inet6Address)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void finishResolve(Promise<T> promise) {
        if (!this.queriesInProgress.isEmpty()) {
            InternetProtocolFamily[] internetProtocolFamilyArray = this.queriesInProgress.iterator();
            while (internetProtocolFamilyArray.hasNext()) {
                Future future = (Future)internetProtocolFamilyArray.next();
                internetProtocolFamilyArray.remove();
                if (future.cancel(false)) continue;
                future.addListener(RELEASE_RESPONSE);
            }
        }
        if (this.resolvedEntries != null) {
            for (InternetProtocolFamily internetProtocolFamily : this.resolveAddressTypes) {
                if (!this.finishResolve(internetProtocolFamily.addressType(), this.resolvedEntries, promise)) continue;
                return;
            }
        }
        int n = this.maxAllowedQueries - this.allowedQueries;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("failed to resolve '").append(this.hostname).append('\'');
        if (n > 1) {
            if (n < this.maxAllowedQueries) {
                stringBuilder.append(" after ").append(n).append(" queries ");
            } else {
                stringBuilder.append(". Exceeded max queries per resolve ").append(this.maxAllowedQueries).append(' ');
            }
        }
        if (this.trace != null) {
            stringBuilder.append(':').append((CharSequence)this.trace);
        }
        UnknownHostException unknownHostException = new UnknownHostException(stringBuilder.toString());
        this.resolveCache.cache(this.hostname, unknownHostException, this.parent.ch.eventLoop());
        promise.tryFailure(unknownHostException);
    }

    abstract boolean finishResolve(Class<? extends InetAddress> var1, List<DnsCacheEntry> var2, Promise<T> var3);

    abstract DnsNameResolverContext<T> newResolverContext(DnsNameResolver var1, String var2, DnsCache var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeDomainName(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        try {
            String string = DefaultDnsRecordDecoder.decodeName(byteBuf);
            return string;
        }
        catch (CorruptedFrameException corruptedFrameException) {
            String string = null;
            return string;
        }
        finally {
            byteBuf.resetReaderIndex();
        }
    }

    private void followCname(InetSocketAddress inetSocketAddress, String string, String string2, Promise<T> promise) {
        if (this.traceEnabled) {
            if (this.trace == null) {
                this.trace = new StringBuilder(128);
            }
            this.trace.append(StringUtil.NEWLINE);
            this.trace.append("\tfrom ");
            this.trace.append(inetSocketAddress);
            this.trace.append(": ");
            this.trace.append(string);
            this.trace.append(" CNAME ");
            this.trace.append(string2);
        }
        InetSocketAddress inetSocketAddress2 = this.nameServerAddrs.next();
        this.query(inetSocketAddress2, new DefaultDnsQuestion(string2, DnsRecordType.A), promise);
        this.query(inetSocketAddress2, new DefaultDnsQuestion(string2, DnsRecordType.AAAA), promise);
    }

    private void addTrace(InetSocketAddress inetSocketAddress, String string) {
        assert (this.traceEnabled);
        if (this.trace == null) {
            this.trace = new StringBuilder(128);
        }
        this.trace.append(StringUtil.NEWLINE);
        this.trace.append("\tfrom ");
        this.trace.append(inetSocketAddress);
        this.trace.append(": ");
        this.trace.append(string);
    }

    private void addTrace(Throwable throwable) {
        assert (this.traceEnabled);
        if (this.trace == null) {
            this.trace = new StringBuilder(128);
        }
        this.trace.append(StringUtil.NEWLINE);
        this.trace.append("Caused by: ");
        this.trace.append(throwable);
    }
}

