/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AddressResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AddressResolverGroup.class);
    private final Map<EventExecutor, AddressResolver<T>> resolvers = new IdentityHashMap<EventExecutor, AddressResolver<T>>();

    protected AddressResolverGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressResolver<T> getResolver(final EventExecutor eventExecutor) {
        AddressResolver<T> addressResolver;
        if (eventExecutor == null) {
            throw new NullPointerException("executor");
        }
        if (eventExecutor.isShuttingDown()) {
            throw new IllegalStateException("executor not accepting a task");
        }
        Map<EventExecutor, AddressResolver<T>> map = this.resolvers;
        synchronized (map) {
            addressResolver = this.resolvers.get(eventExecutor);
            if (addressResolver == null) {
                AddressResolver<T> addressResolver2;
                try {
                    addressResolver2 = this.newResolver(eventExecutor);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to create a new resolver", exception);
                }
                this.resolvers.put(eventExecutor, addressResolver2);
                eventExecutor.terminationFuture().addListener(new FutureListener<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void operationComplete(Future<Object> future) throws Exception {
                        Map map = AddressResolverGroup.this.resolvers;
                        synchronized (map) {
                            AddressResolverGroup.this.resolvers.remove(eventExecutor);
                        }
                        addressResolver2.close();
                    }
                });
                addressResolver = addressResolver2;
            }
        }
        return addressResolver;
    }

    protected abstract AddressResolver<T> newResolver(EventExecutor var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AddressResolver[] addressResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            AddressResolver[] addressResolverArray2 = this.resolvers.values().toArray(new AddressResolver[this.resolvers.size()]);
            this.resolvers.clear();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (AddressResolver addressResolver : addressResolverArray2) {
                try {
                    addressResolver.close();
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to close a resolver:", throwable);
                }
            }
            return;
        }
    }
}

