/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.base64.Base64Dialect;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;

final class SslUtils {
    public static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    public static final int SSL_CONTENT_TYPE_ALERT = 21;
    public static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    public static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    public static final int SSL_RECORD_HEADER_LENGTH = 5;

    static int getEncryptedPacketLength(ByteBuf byteBuf, int n) {
        int n2;
        boolean bl;
        int n3 = 0;
        switch (byteBuf.getUnsignedByte(n)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            n2 = byteBuf.getUnsignedByte(n + 1);
            if (n2 == 3) {
                n3 = byteBuf.getUnsignedShort(n + 3) + 5;
                if (n3 <= 5) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        if (!bl) {
            n2 = (byteBuf.getUnsignedByte(n) & 0x80) != 0 ? 2 : 3;
            short s = byteBuf.getUnsignedByte(n + n2 + 1);
            if (s == 2 || s == 3) {
                n3 = n2 == 2 ? (byteBuf.getShort(n) & Short.MAX_VALUE) + 2 : (byteBuf.getShort(n) & 0x3FFF) + 3;
                if (n3 <= n2) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        return n3;
    }

    static void notifyHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.flush();
        channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!byteBuf.isReadOnly()) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), true, Base64Dialect.STANDARD, byteBufAllocator);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    private SslUtils() {
    }
}

