/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.AsyncMapping;
import io.netty.util.CharsetUtil;
import io.netty.util.DomainNameMapping;
import io.netty.util.Mapping;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.IDN;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;

public class SniHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final int MAX_SSL_RECORDS = 4;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SniHandler.class);
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    private final AsyncMapping<String, SslContext> mapping;
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private volatile Selection selection = EMPTY_SELECTION;

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter(mapping));
    }

    public SniHandler(DomainNameMapping<? extends SslContext> domainNameMapping) {
        this((Mapping<? super String, ? extends SslContext>)domainNameMapping);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> asyncMapping) {
        this.mapping = ObjectUtil.checkNotNull(asyncMapping, "mapping");
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext var1_1, ByteBuf var2_2, List<Object> var3_3) throws Exception {
        if (!this.suppressRead && !this.handshakeFailed) {
            block18: {
                var4_4 = var2_2.writerIndex();
                try {
                    block6: for (var5_5 = 0; var5_5 < 4; ++var5_5) {
                        var6_7 = var2_2.readerIndex();
                        var7_8 = var4_4 - var6_7;
                        if (var7_8 < 5) {
                            return;
                        }
                        var8_9 = var2_2.getUnsignedByte(var6_7);
                        switch (var8_9) {
                            case 20: 
                            case 21: {
                                var9_10 = SslUtils.getEncryptedPacketLength(var2_2, var6_7);
                                if (var9_10 == -1) {
                                    this.handshakeFailed = true;
                                    var10_11 = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(var2_2));
                                    var2_2.skipBytes(var2_2.readableBytes());
                                    var1_1.fireExceptionCaught(var10_11);
                                    SslUtils.notifyHandshakeFailure(var1_1, var10_11);
                                    return;
                                }
                                if (var4_4 - var6_7 - 5 < var9_10) {
                                    return;
                                }
                                var2_2.skipBytes(var9_10);
                                continue block6;
                            }
                            case 22: {
                                var10_12 = var2_2.getUnsignedByte(var6_7 + 1);
                                if (var10_12 == 3) {
                                    var11_13 = var2_2.getUnsignedShort(var6_7 + 3) + 5;
                                    if (var7_8 < var11_13) {
                                        return;
                                    }
                                    var12_14 = var6_7 + var11_13;
                                    var13_15 = var6_7 + 43;
                                    if (var12_14 - var13_15 < 6) break block18;
                                    var14_16 = var2_2.getUnsignedByte(var13_15);
                                    var15_17 = var2_2.getUnsignedShort(var13_15 += var14_16 + 1);
                                    var16_18 = var2_2.getUnsignedByte(var13_15 += var15_17 + 2);
                                    var13_15 += var16_18 + 1;
                                    ** if ((var18_20 = (var13_15 += 2) + (var17_19 = var2_2.getUnsignedShort((int)var13_15))) > var12_14) goto lbl56
                                    while (var18_20 - var13_15 >= 4) {
                                        var19_21 = var2_2.getUnsignedShort(var13_15);
                                        var13_15 += 2;
                                        if (var18_20 - (var13_15 += 2) < (var20_22 = var2_2.getUnsignedShort(var13_15))) break block18;
                                        if (var19_21 == 0) {
                                            if (var18_20 - (var13_15 += 2) >= 3) {
                                                var21_23 = var2_2.getUnsignedByte(var13_15);
                                                ++var13_15;
                                                if (var21_23 == 0 && var18_20 - (var13_15 += 2) >= (var22_24 = var2_2.getUnsignedShort(var13_15))) {
                                                    var23_25 = var2_2.toString(var13_15, var22_24, CharsetUtil.UTF_8);
                                                    this.select(var1_1, IDN.toASCII(var23_25, 1).toLowerCase(Locale.US));
                                                    return;
                                                }
                                            }
                                            break block18;
                                        }
                                        var13_15 += var20_22;
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
lbl56:
                                    // 2 sources

                                    break block18;
                                }
                            }
                            default: {
                                break block18;
                            }
                        }
                    }
                }
                catch (Throwable var5_6) {
                    if (!SniHandler.logger.isDebugEnabled()) break block18;
                    SniHandler.logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(var2_2), var5_6);
                }
            }
            this.select(var1_1, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void select(final ChannelHandlerContext channelHandlerContext, final String string) {
        Future<SslContext> future = this.mapping.map(string, channelHandlerContext.executor().newPromise());
        if (future.isDone()) {
            if (!future.isSuccess()) throw new DecoderException("failed to get the SslContext for " + string, future.cause());
            this.replaceHandler(channelHandlerContext, new Selection(future.getNow(), string));
            return;
        } else {
            this.suppressRead = true;
            future.addListener((GenericFutureListener<Future<SslContext>>)new FutureListener<SslContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(Future<SslContext> future) throws Exception {
                    try {
                        SniHandler.this.suppressRead = false;
                        if (future.isSuccess()) {
                            SniHandler.this.replaceHandler(channelHandlerContext, new Selection(future.getNow(), string));
                        } else {
                            channelHandlerContext.fireExceptionCaught(new DecoderException("failed to get the SslContext for " + string, future.cause()));
                        }
                    }
                    finally {
                        if (SniHandler.this.readPending) {
                            SniHandler.this.readPending = false;
                            channelHandlerContext.read();
                        }
                    }
                }
            });
        }
    }

    private void replaceHandler(ChannelHandlerContext channelHandlerContext, Selection selection) {
        this.selection = selection;
        SslHandler sslHandler = selection.context.newHandler(channelHandlerContext.alloc());
        channelHandlerContext.pipeline().replace(this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            channelHandlerContext.read();
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.flush();
    }

    private static final class Selection {
        final SslContext context;
        final String hostname;

        Selection(SslContext sslContext, String string) {
            this.context = sslContext;
            this.hostname = string;
        }
    }

    private static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            this.mapping = ObjectUtil.checkNotNull(mapping, "mapping");
        }

        @Override
        public Future<SslContext> map(String string, Promise<SslContext> promise) {
            SslContext sslContext;
            try {
                sslContext = this.mapping.map(string);
            }
            catch (Throwable throwable) {
                return promise.setFailure(throwable);
            }
            return promise.setSuccess(sslContext);
        }
    }
}

