/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.util.internal.ObjectUtil;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.apache.tomcat.jni.SSLContext;
import org.apache.tomcat.jni.SessionTicketKey;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private static final Enumeration<byte[]> EMPTY = new EmptyEnumeration();
    private final OpenSslSessionStats stats;
    final OpenSslContext context;

    OpenSslSessionContext(OpenSslContext openSslContext) {
        this.context = openSslContext;
        this.stats = new OpenSslSessionStats(openSslContext);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("bytes");
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    @Deprecated
    public void setTicketKeys(byte[] byArray) {
        ObjectUtil.checkNotNull(byArray, "keys");
        SSLContext.clearOptions((long)this.context.ctx, (int)16384);
        SSLContext.setSessionTicketKeys((long)this.context.ctx, (byte[])byArray);
    }

    public void setTicketKeys(OpenSslSessionTicketKey ... openSslSessionTicketKeyArray) {
        ObjectUtil.checkNotNull(openSslSessionTicketKeyArray, "keys");
        SSLContext.clearOptions((long)this.context.ctx, (int)16384);
        SessionTicketKey[] sessionTicketKeyArray = new SessionTicketKey[openSslSessionTicketKeyArray.length];
        for (int i = 0; i < sessionTicketKeyArray.length; ++i) {
            sessionTicketKeyArray[i] = openSslSessionTicketKeyArray[i].key;
        }
        SSLContext.setSessionTicketKeys((long)this.context.ctx, (SessionTicketKey[])sessionTicketKeyArray);
    }

    public abstract void setSessionCacheEnabled(boolean var1);

    public abstract boolean isSessionCacheEnabled();

    public OpenSslSessionStats stats() {
        return this.stats;
    }

    private static final class EmptyEnumeration
    implements Enumeration<byte[]> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public byte[] nextElement() {
            throw new NoSuchElementException();
        }
    }
}

