/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty.util.NetUtil;
import java.util.List;

public class Socks4ClientDecoder
extends ReplayingDecoder<State> {
    public Socks4ClientDecoder() {
        super(State.START);
        this.setSingleDecode(true);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        try {
            switch ((State)((Object)this.state())) {
                case START: {
                    int n = byteBuf.readUnsignedByte();
                    if (n != 0) {
                        throw new DecoderException("unsupported reply version: " + n + " (expected: 0)");
                    }
                    Socks4CommandStatus socks4CommandStatus = Socks4CommandStatus.valueOf(byteBuf.readByte());
                    int n2 = byteBuf.readUnsignedShort();
                    String string = NetUtil.intToIpAddress(byteBuf.readInt());
                    list.add(new DefaultSocks4CommandResponse(socks4CommandStatus, string, n2));
                    this.checkpoint(State.SUCCESS);
                }
                case SUCCESS: {
                    int n = this.actualReadableBytes();
                    if (n <= 0) break;
                    list.add(byteBuf.readRetainedSlice(n));
                    break;
                }
                case FAILURE: {
                    byteBuf.skipBytes(this.actualReadableBytes());
                }
            }
        }
        catch (Exception exception) {
            this.fail(list, exception);
        }
    }

    private void fail(List<Object> list, Throwable throwable) {
        if (!(throwable instanceof DecoderException)) {
            throwable = new DecoderException(throwable);
        }
        DefaultSocks4CommandResponse defaultSocks4CommandResponse = new DefaultSocks4CommandResponse(Socks4CommandStatus.REJECTED_OR_FAILED);
        defaultSocks4CommandResponse.setDecoderResult(DecoderResult.failure(throwable));
        list.add(defaultSocks4CommandResponse);
        this.checkpoint(State.FAILURE);
    }

    static enum State {
        START,
        SUCCESS,
        FAILURE;

    }
}

