/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;

public class DefaultFullBinaryMemcacheResponse
extends DefaultBinaryMemcacheResponse
implements FullBinaryMemcacheResponse {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheResponse(ByteBuf byteBuf, ByteBuf byteBuf2) {
        this(byteBuf, byteBuf2, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheResponse(ByteBuf byteBuf, ByteBuf byteBuf2, ByteBuf byteBuf3) {
        super(byteBuf, byteBuf2);
        if (byteBuf3 == null) {
            throw new NullPointerException("Supplied content is null.");
        }
        this.content = byteBuf3;
        this.setTotalBodyLength(this.keyLength() + this.extrasLength() + byteBuf3.readableBytes());
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public FullBinaryMemcacheResponse retain() {
        super.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse touch() {
        super.touch();
        return this;
    }

    @Override
    public FullBinaryMemcacheResponse touch(Object object) {
        super.touch(object);
        this.content.touch(object);
        return this;
    }

    @Override
    protected void deallocate() {
        super.deallocate();
        this.content.release();
    }

    @Override
    public FullBinaryMemcacheResponse copy() {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = this.key();
        if (byteBuf2 != null) {
            byteBuf2 = byteBuf2.copy();
        }
        if ((byteBuf = this.extras()) != null) {
            byteBuf = byteBuf.copy();
        }
        return new DefaultFullBinaryMemcacheResponse(byteBuf2, byteBuf, this.content().copy());
    }

    @Override
    public FullBinaryMemcacheResponse duplicate() {
        ByteBuf byteBuf;
        ByteBuf byteBuf2 = this.key();
        if (byteBuf2 != null) {
            byteBuf2 = byteBuf2.duplicate();
        }
        if ((byteBuf = this.extras()) != null) {
            byteBuf = byteBuf.duplicate();
        }
        return new DefaultFullBinaryMemcacheResponse(byteBuf2, byteBuf, this.content().duplicate());
    }

    @Override
    public FullBinaryMemcacheResponse retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullBinaryMemcacheResponse replace(ByteBuf byteBuf) {
        ByteBuf byteBuf2;
        ByteBuf byteBuf3 = this.key();
        if (byteBuf3 != null) {
            byteBuf3 = byteBuf3.retainedDuplicate();
        }
        if ((byteBuf2 = this.extras()) != null) {
            byteBuf2 = byteBuf2.retainedDuplicate();
        }
        return new DefaultFullBinaryMemcacheResponse(byteBuf3, byteBuf2, byteBuf);
    }
}

