/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.util.internal.ObjectUtil;

class HeaderField {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    final CharSequence name;
    final CharSequence value;

    static int sizeOf(CharSequence charSequence, CharSequence charSequence2) {
        return charSequence.length() + charSequence2.length() + 32;
    }

    HeaderField(CharSequence charSequence, CharSequence charSequence2) {
        this.name = ObjectUtil.checkNotNull(charSequence, "name");
        this.value = ObjectUtil.checkNotNull(charSequence2, "value");
    }

    int size() {
        return this.name.length() + this.value.length() + 32;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HeaderField)) {
            return false;
        }
        HeaderField headerField = (HeaderField)object;
        return (HpackUtil.equalsConstantTime(this.name, headerField.name) & HpackUtil.equalsConstantTime(this.value, headerField.value)) != 0;
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

