/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;

public class InboundHttpToHttp2Adapter
extends ChannelInboundHandlerAdapter {
    private final Http2Connection connection;
    private final Http2FrameListener listener;

    public InboundHttpToHttp2Adapter(Http2Connection http2Connection, Http2FrameListener http2FrameListener) {
        this.connection = http2Connection;
        this.listener = http2FrameListener;
    }

    private int getStreamId(HttpHeaders httpHeaders) {
        return httpHeaders.getInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection.remote().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof FullHttpMessage) {
            FullHttpMessage fullHttpMessage = (FullHttpMessage)object;
            try {
                int n = this.getStreamId(fullHttpMessage.headers());
                Http2Stream http2Stream = this.connection.stream(n);
                if (http2Stream == null) {
                    http2Stream = this.connection.remote().createStream(n, false);
                }
                fullHttpMessage.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)HttpScheme.HTTP.name());
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(fullHttpMessage, true);
                boolean bl = fullHttpMessage.content().isReadable();
                boolean bl2 = !fullHttpMessage.trailingHeaders().isEmpty();
                this.listener.onHeadersRead(channelHandlerContext, n, http2Headers, 0, !bl && !bl2);
                if (bl) {
                    this.listener.onDataRead(channelHandlerContext, n, fullHttpMessage.content(), 0, !bl2);
                }
                if (bl2) {
                    Http2Headers http2Headers2 = HttpConversionUtil.toHttp2Headers(fullHttpMessage.trailingHeaders(), true);
                    this.listener.onHeadersRead(channelHandlerContext, n, http2Headers2, 0, true);
                }
                http2Stream.closeRemoteSide();
            }
            finally {
                fullHttpMessage.release();
            }
        } else {
            super.channelRead(channelHandlerContext, object);
        }
    }
}

