/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2StreamVisitor;

public interface Http2Stream {
    public int id();

    public State state();

    public Http2Stream open(boolean var1) throws Http2Exception;

    public Http2Stream close();

    public Http2Stream closeLocalSide();

    public Http2Stream closeRemoteSide();

    public boolean isResetSent();

    public Http2Stream resetSent();

    public <V> V setProperty(Http2Connection.PropertyKey var1, V var2);

    public <V> V getProperty(Http2Connection.PropertyKey var1);

    public <V> V removeProperty(Http2Connection.PropertyKey var1);

    public Http2Stream setPriority(int var1, short var2, boolean var3) throws Http2Exception;

    public boolean isRoot();

    public boolean isLeaf();

    public short weight();

    public Http2Stream parent();

    public boolean isDescendantOf(Http2Stream var1);

    public int numChildren();

    public Http2Stream forEachChild(Http2StreamVisitor var1) throws Http2Exception;

    public static enum State {
        IDLE(false, false),
        RESERVED_LOCAL(false, false),
        RESERVED_REMOTE(false, false),
        OPEN(true, true),
        HALF_CLOSED_LOCAL(false, true),
        HALF_CLOSED_REMOTE(true, false),
        CLOSED(false, false);

        private final boolean localSideOpen;
        private final boolean remoteSideOpen;

        private State(boolean bl, boolean bl2) {
            this.localSideOpen = bl;
            this.remoteSideOpen = bl2;
        }

        public boolean localSideOpen() {
            return this.localSideOpen;
        }

        public boolean remoteSideOpen() {
            return this.remoteSideOpen;
        }
    }
}

