/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.ObjectUtil;

public class Http2InboundFrameLogger
implements Http2FrameReader {
    private final Http2FrameReader reader;
    private final Http2FrameLogger logger;

    public Http2InboundFrameLogger(Http2FrameReader http2FrameReader, Http2FrameLogger http2FrameLogger) {
        this.reader = ObjectUtil.checkNotNull(http2FrameReader, "reader");
        this.logger = ObjectUtil.checkNotNull(http2FrameLogger, "logger");
    }

    @Override
    public void readFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, final Http2FrameListener http2FrameListener) throws Http2Exception {
        this.reader.readFrame(channelHandlerContext, byteBuf, new Http2FrameListener(){

            @Override
            public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logData(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, byteBuf, n2, bl);
                return http2FrameListener.onDataRead(channelHandlerContext, n, byteBuf, n2, bl);
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logHeaders(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, http2Headers, n2, bl);
                http2FrameListener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, bl);
            }

            @Override
            public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logHeaders(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
                http2FrameListener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
            }

            @Override
            public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPriority(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, n2, s, bl);
                http2FrameListener.onPriorityRead(channelHandlerContext, n, n2, s, bl);
            }

            @Override
            public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logRstStream(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, l);
                http2FrameListener.onRstStreamRead(channelHandlerContext, n, l);
            }

            @Override
            public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logSettingsAck(Http2FrameLogger.Direction.INBOUND, channelHandlerContext);
                http2FrameListener.onSettingsAckRead(channelHandlerContext);
            }

            @Override
            public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logSettings(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, http2Settings);
                http2FrameListener.onSettingsRead(channelHandlerContext, http2Settings);
            }

            @Override
            public void onPingRead(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPing(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, byteBuf);
                http2FrameListener.onPingRead(channelHandlerContext, byteBuf);
            }

            @Override
            public void onPingAckRead(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPingAck(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, byteBuf);
                http2FrameListener.onPingAckRead(channelHandlerContext, byteBuf);
            }

            @Override
            public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logPushPromise(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, n2, http2Headers, n3);
                http2FrameListener.onPushPromiseRead(channelHandlerContext, n, n2, http2Headers, n3);
            }

            @Override
            public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logGoAway(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, l, byteBuf);
                http2FrameListener.onGoAwayRead(channelHandlerContext, n, l, byteBuf);
            }

            @Override
            public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logWindowsUpdate(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, n, n2);
                http2FrameListener.onWindowUpdateRead(channelHandlerContext, n, n2);
            }

            @Override
            public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
                Http2InboundFrameLogger.this.logger.logUnknownFrame(Http2FrameLogger.Direction.INBOUND, channelHandlerContext, by, n, http2Flags, byteBuf);
                http2FrameListener.onUnknownFrame(channelHandlerContext, by, n, http2Flags, byteBuf);
            }
        });
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public Http2FrameReader.Configuration configuration() {
        return this.reader.configuration();
    }
}

