/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.DefaultHttp2HeaderTableListSize;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.internal.hpack.Decoder;
import java.io.IOException;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private static final float HEADERS_COUNT_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_COUNT_WEIGHT_HISTORICAL = 0.8f;
    private final int maxHeaderSize;
    private final Decoder decoder;
    private final Http2HeaderTable headerTable;
    private final boolean validateHeaders;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    public DefaultHttp2HeadersDecoder(boolean bl) {
        this(8192, 4096, bl, 32);
    }

    public DefaultHttp2HeadersDecoder(int n, int n2, boolean bl, int n3) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxHeaderSize must be positive: " + n);
        }
        this.decoder = new Decoder(n, n2, n3);
        this.headerTable = new Http2HeaderTableDecoder();
        this.maxHeaderSize = n;
        this.validateHeaders = bl;
    }

    @Override
    public Http2HeaderTable headerTable() {
        return this.headerTable;
    }

    @Override
    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    protected void maxHeaderSizeExceeded() throws Http2Exception {
        throw Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Header size exceeded max allowed bytes (%d)", this.maxHeaderSize);
    }

    @Override
    public Http2Headers decodeHeaders(ByteBuf byteBuf) throws Http2Exception {
        try {
            DefaultHttp2Headers defaultHttp2Headers = new DefaultHttp2Headers(this.validateHeaders, (int)this.headerArraySizeAccumulator);
            this.decoder.decode(byteBuf, defaultHttp2Headers);
            if (this.decoder.endHeaderBlock()) {
                this.maxHeaderSizeExceeded();
            }
            if (defaultHttp2Headers.size() > this.headerTable.maxHeaderListSize()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Number of headers (%d) exceeds maxHeaderListSize (%d)", defaultHttp2Headers.size(), this.headerTable.maxHeaderListSize());
            }
            this.headerArraySizeAccumulator = 0.2f * (float)defaultHttp2Headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return defaultHttp2Headers;
        }
        catch (IOException iOException) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, iOException, iOException.getMessage(), new Object[0]);
        }
        catch (Http2Exception http2Exception) {
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, throwable, throwable.getMessage(), new Object[0]);
        }
    }

    private final class Http2HeaderTableDecoder
    extends DefaultHttp2HeaderTableListSize
    implements Http2HeaderTable {
        private Http2HeaderTableDecoder() {
        }

        @Override
        public void maxHeaderTableSize(int n) throws Http2Exception {
            if (n < 0) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be non-negative but was %d", n);
            }
            try {
                DefaultHttp2HeadersDecoder.this.decoder.setMaxHeaderTableSize(n);
            }
            catch (Throwable throwable) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, throwable.getMessage(), throwable);
            }
        }

        @Override
        public int maxHeaderTableSize() {
            return DefaultHttp2HeadersDecoder.this.decoder.getMaxHeaderTableSize();
        }
    }
}

