/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2HeaderTable;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class DefaultHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new PrefaceFrameListener();
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameReader = ObjectUtil.checkNotNull(http2FrameReader, "frameReader");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        this.requestVerifier = ObjectUtil.checkNotNull(http2PromisedRequestVerifier, "requestVerifier");
        if (http2Connection.local().flowController() == null) {
            http2Connection.local().flowController(new DefaultHttp2LocalFlowController(http2Connection));
        }
        http2Connection.local().flowController().frameWriter(http2ConnectionEncoder.frameWriter());
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2LocalFlowController flowController() {
        return this.connection.local().flowController();
    }

    @Override
    public void frameListener(Http2FrameListener http2FrameListener) {
        this.listener = ObjectUtil.checkNotNull(http2FrameListener, "listener");
    }

    @Override
    public Http2FrameListener frameListener() {
        return this.listener;
    }

    Http2FrameListener internalFrameListener() {
        return this.internalFrameListener;
    }

    @Override
    public boolean prefaceReceived() {
        return FrameReadListener.class == this.internalFrameListener.getClass();
    }

    @Override
    public void decodeFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Http2Exception {
        this.frameReader.readFrame(channelHandlerContext, byteBuf, this.internalFrameListener);
    }

    @Override
    public Http2Settings localSettings() {
        Http2Settings http2Settings = new Http2Settings();
        Http2FrameReader.Configuration configuration = this.frameReader.configuration();
        Http2HeaderTable http2HeaderTable = configuration.headerTable();
        Http2FrameSizePolicy http2FrameSizePolicy = configuration.frameSizePolicy();
        http2Settings.initialWindowSize(this.flowController().initialWindowSize());
        http2Settings.maxConcurrentStreams(this.connection.remote().maxActiveStreams());
        http2Settings.headerTableSize(http2HeaderTable.maxHeaderTableSize());
        http2Settings.maxFrameSize(http2FrameSizePolicy.maxFrameSize());
        http2Settings.maxHeaderListSize(http2HeaderTable.maxHeaderListSize());
        if (!this.connection.isServer()) {
            http2Settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return http2Settings;
    }

    @Override
    public void localSettings(Http2Settings http2Settings) throws Http2Exception {
        Integer n;
        Integer n2;
        Integer n3;
        Long l;
        Long l2;
        Boolean bl = http2Settings.pushEnabled();
        Http2FrameReader.Configuration configuration = this.frameReader.configuration();
        Http2HeaderTable http2HeaderTable = configuration.headerTable();
        Http2FrameSizePolicy http2FrameSizePolicy = configuration.frameSizePolicy();
        if (bl != null) {
            if (this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
            this.connection.local().allowPushTo(bl);
        }
        if ((l2 = http2Settings.maxConcurrentStreams()) != null) {
            int n4 = (int)Math.min(l2, Integer.MAX_VALUE);
            this.connection.remote().maxActiveStreams(n4);
        }
        if ((l = http2Settings.headerTableSize()) != null) {
            http2HeaderTable.maxHeaderTableSize((int)Math.min(l, Integer.MAX_VALUE));
        }
        if ((n3 = http2Settings.maxHeaderListSize()) != null) {
            http2HeaderTable.maxHeaderListSize(n3);
        }
        if ((n2 = http2Settings.maxFrameSize()) != null) {
            http2FrameSizePolicy.maxFrameSize(n2);
        }
        if ((n = http2Settings.initialWindowSize()) != null) {
            this.flowController().initialWindowSize(n);
        }
    }

    @Override
    public void close() {
        this.frameReader.close();
    }

    private int unconsumedBytes(Http2Stream http2Stream) {
        return this.flowController().unconsumedBytes(http2Stream);
    }

    void onGoAwayRead0(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) throws Http2Exception {
        if (this.connection.goAwayReceived() && this.connection.local().lastStreamKnownByPeer() < n) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "lastStreamId MUST NOT increase. Current value: %d new value: %d", this.connection.local().lastStreamKnownByPeer(), n);
        }
        this.listener.onGoAwayRead(channelHandlerContext, n, l, byteBuf);
        this.connection.goAwayReceived(n, l, byteBuf);
    }

    void onUnknownFrame0(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
        this.listener.onUnknownFrame(channelHandlerContext, by, n, http2Flags, byteBuf);
    }

    private final class PrefaceFrameListener
    implements Http2FrameListener {
        private PrefaceFrameListener() {
        }

        private void verifyPrefaceReceived() throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received non-SETTINGS as first frame.", new Object[0]);
            }
        }

        @Override
        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
            this.verifyPrefaceReceived();
            return DefaultHttp2ConnectionDecoder.this.internalFrameListener.onDataRead(channelHandlerContext, n, byteBuf, n2, bl);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, bl);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
        }

        @Override
        public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPriorityRead(channelHandlerContext, n, n2, s, bl);
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onRstStreamRead(channelHandlerContext, n, l);
        }

        @Override
        public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsAckRead(channelHandlerContext);
        }

        @Override
        public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.prefaceReceived()) {
                DefaultHttp2ConnectionDecoder.this.internalFrameListener = new FrameReadListener();
            }
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onSettingsRead(channelHandlerContext, http2Settings);
        }

        @Override
        public void onPingRead(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingRead(channelHandlerContext, byteBuf);
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPingAckRead(channelHandlerContext, byteBuf);
        }

        @Override
        public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onPushPromiseRead(channelHandlerContext, n, n2, http2Headers, n3);
        }

        @Override
        public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0(channelHandlerContext, n, l, byteBuf);
        }

        @Override
        public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) throws Http2Exception {
            this.verifyPrefaceReceived();
            DefaultHttp2ConnectionDecoder.this.internalFrameListener.onWindowUpdateRead(channelHandlerContext, n, n2);
        }

        @Override
        public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0(channelHandlerContext, by, n, http2Flags, byteBuf);
        }
    }

    private final class FrameReadListener
    implements Http2FrameListener {
        private FrameReadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n, ByteBuf byteBuf, int n2, boolean bl) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            Http2LocalFlowController http2LocalFlowController = DefaultHttp2ConnectionDecoder.this.flowController();
            int n3 = byteBuf.readableBytes() + n2;
            boolean bl2 = true;
            try {
                bl2 = this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n, http2Stream, "DATA");
            }
            finally {
                if (bl2) {
                    http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n2, bl);
                    http2LocalFlowController.consumeBytes(http2Stream, n3);
                    this.verifyStreamMayHaveExisted(n);
                    return n3;
                }
            }
            Http2Exception http2Exception = null;
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: 
                case CLOSED: {
                    http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                    break;
                }
                default: {
                    http2Exception = Http2Exception.streamError(http2Stream.id(), Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            int n4 = DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
            try {
                http2LocalFlowController.receiveFlowControlledFrame(http2Stream, byteBuf, n2, bl);
                n4 = DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                if (http2Exception != null) {
                    throw http2Exception;
                }
                int n5 = n3 = DefaultHttp2ConnectionDecoder.this.listener.onDataRead(channelHandlerContext, n, byteBuf, n2, bl);
                return n5;
            }
            catch (Http2Exception http2Exception2) {
                int n6 = n4 - DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                n3 -= n6;
                throw http2Exception2;
            }
            catch (RuntimeException runtimeException) {
                int n7 = n4 - DefaultHttp2ConnectionDecoder.this.unconsumedBytes(http2Stream);
                n3 -= n7;
                throw runtimeException;
            }
            finally {
                http2LocalFlowController.consumeBytes(http2Stream, n3);
                if (bl) {
                    DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
                }
            }
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, boolean bl) throws Http2Exception {
            this.onHeadersRead(channelHandlerContext, n, http2Headers, 0, (short)16, false, n2, bl);
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n, Http2Headers http2Headers, int n2, short s, boolean bl, int n3, boolean bl2) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            boolean bl3 = false;
            if (http2Stream == null && !DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(n)) {
                http2Stream = DefaultHttp2ConnectionDecoder.this.connection.remote().createStream(n, bl2);
                boolean bl4 = bl3 = http2Stream.state() == Http2Stream.State.HALF_CLOSED_REMOTE;
            }
            if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n, http2Stream, "HEADERS")) {
                return;
            }
            switch (http2Stream.state()) {
                case RESERVED_REMOTE: {
                    http2Stream.open(bl2);
                    break;
                }
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                case HALF_CLOSED_REMOTE: {
                    if (bl3) break;
                    throw Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
                case CLOSED: {
                    throw Http2Exception.streamError(http2Stream.id(), Http2Error.STREAM_CLOSED, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            try {
                http2Stream.setPriority(n2, s, bl);
            }
            catch (Http2Exception.ClosedStreamCreationException closedStreamCreationException) {
                // empty catch block
            }
            DefaultHttp2ConnectionDecoder.this.listener.onHeadersRead(channelHandlerContext, n, http2Headers, n2, s, bl, n3, bl2);
            if (bl2) {
                DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStreamRemote(http2Stream, channelHandlerContext.newSucceededFuture());
            }
        }

        @Override
        public void onPriorityRead(ChannelHandlerContext channelHandlerContext, int n, int n2, short s, boolean bl) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            try {
                if (http2Stream == null) {
                    if (DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(n)) {
                        logger.info("{} ignoring PRIORITY frame for stream {}. Stream doesn't exist but may  have existed", (Object)channelHandlerContext.channel(), (Object)n);
                        return;
                    }
                    http2Stream = DefaultHttp2ConnectionDecoder.this.connection.remote().createIdleStream(n);
                } else if (this.streamCreatedAfterGoAwaySent(n)) {
                    logger.info("{} ignoring PRIORITY frame for stream {}. Stream created after GOAWAY sent. Last known stream by peer {}", channelHandlerContext.channel(), n, DefaultHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer());
                    return;
                }
                http2Stream.setPriority(n2, s, bl);
            }
            catch (Http2Exception.ClosedStreamCreationException closedStreamCreationException) {
                // empty catch block
            }
            DefaultHttp2ConnectionDecoder.this.listener.onPriorityRead(channelHandlerContext, n, n2, s, bl);
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n, long l) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            if (http2Stream == null) {
                this.verifyStreamMayHaveExisted(n);
                return;
            }
            switch (http2Stream.state()) {
                case IDLE: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "RST_STREAM received for IDLE stream %d", n);
                }
                case CLOSED: {
                    return;
                }
            }
            DefaultHttp2ConnectionDecoder.this.listener.onRstStreamRead(channelHandlerContext, n, l);
            DefaultHttp2ConnectionDecoder.this.lifecycleManager.closeStream(http2Stream, channelHandlerContext.newSucceededFuture());
        }

        @Override
        public void onSettingsAckRead(ChannelHandlerContext channelHandlerContext) throws Http2Exception {
            Http2Settings http2Settings = DefaultHttp2ConnectionDecoder.this.encoder.pollSentSettings();
            if (http2Settings != null) {
                this.applyLocalSettings(http2Settings);
            }
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsAckRead(channelHandlerContext);
        }

        private void applyLocalSettings(Http2Settings http2Settings) throws Http2Exception {
            Integer n;
            Integer n2;
            Integer n3;
            Long l;
            Long l2;
            Boolean bl = http2Settings.pushEnabled();
            Http2FrameReader.Configuration configuration = DefaultHttp2ConnectionDecoder.this.frameReader.configuration();
            Http2HeaderTable http2HeaderTable = configuration.headerTable();
            Http2FrameSizePolicy http2FrameSizePolicy = configuration.frameSizePolicy();
            if (bl != null) {
                if (DefaultHttp2ConnectionDecoder.this.connection.isServer()) {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
                }
                DefaultHttp2ConnectionDecoder.this.connection.local().allowPushTo(bl);
            }
            if ((l2 = http2Settings.maxConcurrentStreams()) != null) {
                int n4 = (int)Math.min(l2, Integer.MAX_VALUE);
                DefaultHttp2ConnectionDecoder.this.connection.remote().maxActiveStreams(n4);
            }
            if ((l = http2Settings.headerTableSize()) != null) {
                http2HeaderTable.maxHeaderTableSize((int)Math.min(l, Integer.MAX_VALUE));
            }
            if ((n3 = http2Settings.maxHeaderListSize()) != null) {
                http2HeaderTable.maxHeaderListSize(n3);
            }
            if ((n2 = http2Settings.maxFrameSize()) != null) {
                http2FrameSizePolicy.maxFrameSize(n2);
            }
            if ((n = http2Settings.initialWindowSize()) != null) {
                DefaultHttp2ConnectionDecoder.this.flowController().initialWindowSize(n);
            }
        }

        @Override
        public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.encoder.remoteSettings(http2Settings);
            DefaultHttp2ConnectionDecoder.this.encoder.writeSettingsAck(channelHandlerContext, channelHandlerContext.newPromise());
            DefaultHttp2ConnectionDecoder.this.listener.onSettingsRead(channelHandlerContext, http2Settings);
        }

        @Override
        public void onPingRead(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.encoder.writePing(channelHandlerContext, true, byteBuf.retainedSlice(), channelHandlerContext.newPromise());
            DefaultHttp2ConnectionDecoder.this.listener.onPingRead(channelHandlerContext, byteBuf);
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.listener.onPingAckRead(channelHandlerContext, byteBuf);
        }

        @Override
        public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n, int n2, Http2Headers http2Headers, int n3) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            if (this.shouldIgnoreHeadersOrDataFrame(channelHandlerContext, n, http2Stream, "PUSH_PROMISE")) {
                return;
            }
            if (http2Stream == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist", n);
            }
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_LOCAL: {
                    break;
                }
                default: {
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d in unexpected state for receiving push promise: %s", new Object[]{http2Stream.id(), http2Stream.state()});
                }
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isAuthoritative(channelHandlerContext, http2Headers)) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not authoritative", n, n2);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isCacheable(http2Headers)) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be cacheable", n, n2);
            }
            if (!DefaultHttp2ConnectionDecoder.this.requestVerifier.isSafe(http2Headers)) {
                throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Promised request on stream %d for promised stream %d is not known to be safe", n, n2);
            }
            DefaultHttp2ConnectionDecoder.this.connection.remote().reservePushStream(n2, http2Stream);
            DefaultHttp2ConnectionDecoder.this.listener.onPushPromiseRead(channelHandlerContext, n, n2, http2Headers, n3);
        }

        @Override
        public void onGoAwayRead(ChannelHandlerContext channelHandlerContext, int n, long l, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onGoAwayRead0(channelHandlerContext, n, l, byteBuf);
        }

        @Override
        public void onWindowUpdateRead(ChannelHandlerContext channelHandlerContext, int n, int n2) throws Http2Exception {
            Http2Stream http2Stream = DefaultHttp2ConnectionDecoder.this.connection.stream(n);
            if (http2Stream == null || http2Stream.state() == Http2Stream.State.CLOSED || this.streamCreatedAfterGoAwaySent(n)) {
                this.verifyStreamMayHaveExisted(n);
                return;
            }
            DefaultHttp2ConnectionDecoder.this.encoder.flowController().incrementWindowSize(http2Stream, n2);
            DefaultHttp2ConnectionDecoder.this.listener.onWindowUpdateRead(channelHandlerContext, n, n2);
        }

        @Override
        public void onUnknownFrame(ChannelHandlerContext channelHandlerContext, byte by, int n, Http2Flags http2Flags, ByteBuf byteBuf) throws Http2Exception {
            DefaultHttp2ConnectionDecoder.this.onUnknownFrame0(channelHandlerContext, by, n, http2Flags, byteBuf);
        }

        private boolean shouldIgnoreHeadersOrDataFrame(ChannelHandlerContext channelHandlerContext, int n, Http2Stream http2Stream, String string) throws Http2Exception {
            if (http2Stream == null) {
                if (this.streamCreatedAfterGoAwaySent(n)) {
                    logger.info("{} ignoring {} frame for stream {}. Stream sent after GOAWAY sent", channelHandlerContext.channel(), string, n);
                    return true;
                }
                throw Http2Exception.streamError(n, Http2Error.STREAM_CLOSED, "Received %s frame for an unknown stream %d", string, n);
            }
            if (http2Stream.isResetSent() || this.streamCreatedAfterGoAwaySent(n)) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} ignoring {} frame for stream {} {}", channelHandlerContext.channel(), string, http2Stream.isResetSent() ? "RST_STREAM sent." : "Stream created after GOAWAY sent. Last known stream by peer " + DefaultHttp2ConnectionDecoder.this.connection.remote().lastStreamKnownByPeer());
                }
                return true;
            }
            return false;
        }

        private boolean streamCreatedAfterGoAwaySent(int n) {
            Http2Connection.Endpoint<Http2RemoteFlowController> endpoint = DefaultHttp2ConnectionDecoder.this.connection.remote();
            return DefaultHttp2ConnectionDecoder.this.connection.goAwaySent() && endpoint.isValidStreamId(n) && n > endpoint.lastStreamKnownByPeer();
        }

        private void verifyStreamMayHaveExisted(int n) throws Http2Exception {
            if (!DefaultHttp2ConnectionDecoder.this.connection.streamMayHaveExisted(n)) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d does not exist", n);
            }
        }
    }
}

