/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.ValueConverter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.util.AsciiString;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CombinedHttpHeaders
extends DefaultHttpHeaders {
    public CombinedHttpHeaders(boolean bl) {
        super(new CombinedHttpHeadersImpl(AsciiString.CASE_INSENSITIVE_HASHER, CombinedHttpHeaders.valueConverter(bl), CombinedHttpHeaders.nameValidator(bl)));
    }

    private static final class CombinedHttpHeadersImpl
    extends DefaultHeaders<CharSequence, CharSequence, CombinedHttpHeadersImpl> {
        private static final int VALUE_LENGTH_ESTIMATE = 10;
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(Object object) {
                        return StringUtil.escapeCsv((CharSequence)CombinedHttpHeadersImpl.this.valueConverter().convertObject(object));
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence charSequence) {
                        return StringUtil.escapeCsv(charSequence);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        public CombinedHttpHeadersImpl(HashingStrategy<CharSequence> hashingStrategy, ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
            super(hashingStrategy, valueConverter, nameValidator);
        }

        @Override
        public List<CharSequence> getAll(CharSequence charSequence) {
            List<CharSequence> list = super.getAll(charSequence);
            if (list.isEmpty()) {
                return list;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("CombinedHttpHeaders should only have one value");
            }
            return StringUtil.unescapeCsvFields(list.get(0));
        }

        @Override
        public CombinedHttpHeadersImpl add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            if (headers instanceof CombinedHttpHeadersImpl) {
                if (this.isEmpty()) {
                    this.addImpl(headers);
                } else {
                    for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                        this.addEscapedValue(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                for (Map.Entry<CharSequence, CharSequence> entry : headers) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            this.clear();
            return this.add((Headers)headers);
        }

        @Override
        public CombinedHttpHeadersImpl setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            if (headers == this) {
                return this;
            }
            for (CharSequence charSequence : headers.names()) {
                this.remove(charSequence);
            }
            return this.add(headers);
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence charSequence2) {
            return this.addEscapedValue(charSequence, StringUtil.escapeCsv(charSequence2));
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence charSequence, CharSequence ... charSequenceArray) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), charSequenceArray));
        }

        @Override
        public CombinedHttpHeadersImpl add(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), iterable));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence charSequence, Iterable<?> iterable) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), iterable));
        }

        @Override
        public CombinedHttpHeadersImpl addObject(CharSequence charSequence, Object ... objectArray) {
            return this.addEscapedValue(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), objectArray));
        }

        @Override
        public CombinedHttpHeadersImpl set(CharSequence charSequence, CharSequence ... charSequenceArray) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), charSequenceArray));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl set(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.charSequenceEscaper(), iterable));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object object) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), object));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Object ... objectArray) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), objectArray));
            return this;
        }

        @Override
        public CombinedHttpHeadersImpl setObject(CharSequence charSequence, Iterable<?> iterable) {
            super.set(charSequence, CombinedHttpHeadersImpl.commaSeparate(this.objectEscaper(), iterable));
            return this;
        }

        private CombinedHttpHeadersImpl addEscapedValue(CharSequence charSequence, CharSequence charSequence2) {
            CharSequence charSequence3 = (CharSequence)super.get(charSequence);
            if (charSequence3 == null) {
                super.add(charSequence, charSequence2);
            } else {
                super.set(charSequence, this.commaSeparateEscapedValues(charSequence3, charSequence2));
            }
            return this;
        }

        private static <T> CharSequence commaSeparate(CsvValueEscaper<T> csvValueEscaper, T ... TArray) {
            StringBuilder stringBuilder = new StringBuilder(TArray.length * 10);
            if (TArray.length > 0) {
                int n = TArray.length - 1;
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(csvValueEscaper.escape(TArray[i])).append(',');
                }
                stringBuilder.append(csvValueEscaper.escape(TArray[n]));
            }
            return stringBuilder;
        }

        private static <T> CharSequence commaSeparate(CsvValueEscaper<T> csvValueEscaper, Iterable<? extends T> iterable) {
            StringBuilder stringBuilder = iterable instanceof Collection ? new StringBuilder(((Collection)iterable).size() * 10) : new StringBuilder();
            Iterator<T> iterator = iterable.iterator();
            if (iterator.hasNext()) {
                T t = iterator.next();
                while (iterator.hasNext()) {
                    stringBuilder.append(csvValueEscaper.escape(t)).append(',');
                    t = iterator.next();
                }
                stringBuilder.append(csvValueEscaper.escape(t));
            }
            return stringBuilder;
        }

        private CharSequence commaSeparateEscapedValues(CharSequence charSequence, CharSequence charSequence2) {
            return new StringBuilder(charSequence.length() + 1 + charSequence2.length()).append(charSequence).append(',').append(charSequence2);
        }

        private static interface CsvValueEscaper<T> {
            public CharSequence escape(T var1);
        }
    }
}

