/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThrowableUtil;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LocalChannel
extends AbstractChannel {
    private static final AtomicReferenceFieldUpdater<LocalChannel, Future> FINISH_READ_FUTURE_UPDATER;
    private static final ChannelMetadata METADATA;
    private static final int MAX_READER_STACK_DEPTH = 8;
    private static final ClosedChannelException DO_WRITE_CLOSED_CHANNEL_EXCEPTION;
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION;
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final Queue<Object> inboundBuffer = PlatformDependent.newSpscQueue();
    private final Runnable readTask = new Runnable(){

        @Override
        public void run() {
            Object e;
            ChannelPipeline channelPipeline = LocalChannel.this.pipeline();
            while ((e = LocalChannel.this.inboundBuffer.poll()) != null) {
                channelPipeline.fireChannelRead(e);
            }
            channelPipeline.fireChannelReadComplete();
        }
    };
    private final Runnable shutdownHook = new Runnable(){

        @Override
        public void run() {
            LocalChannel.this.unsafe().close(LocalChannel.this.unsafe().voidPromise());
        }
    };
    private volatile State state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile ChannelPromise connectPromise;
    private volatile boolean readInProgress;
    private volatile boolean registerInProgress;
    private volatile boolean writeInProgress;
    private volatile Future<?> finishReadFuture;

    public LocalChannel() {
        super(null);
    }

    LocalChannel(LocalServerChannel localServerChannel, LocalChannel localChannel) {
        super(localServerChannel);
        this.peer = localChannel;
        this.localAddress = localServerChannel.localAddress();
        this.remoteAddress = localChannel.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalServerChannel parent() {
        return (LocalServerChannel)super.parent();
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.CONNECTED;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new LocalUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    @Override
    protected void doRegister() throws Exception {
        if (this.peer != null && this.parent() != null) {
            final LocalChannel localChannel = this.peer;
            this.registerInProgress = true;
            this.state = State.CONNECTED;
            localChannel.remoteAddress = this.parent() == null ? null : this.parent().localAddress();
            localChannel.state = State.CONNECTED;
            localChannel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    LocalChannel.this.registerInProgress = false;
                    ChannelPromise channelPromise = localChannel.connectPromise;
                    if (channelPromise != null && channelPromise.trySuccess()) {
                        localChannel.pipeline().fireChannelActive();
                    }
                }
            });
        }
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).addShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, socketAddress);
        this.state = State.BOUND;
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        final LocalChannel localChannel = this.peer;
        if (this.state != State.CLOSED) {
            if (this.localAddress != null) {
                if (this.parent() == null) {
                    LocalChannelRegistry.unregister(this.localAddress);
                }
                this.localAddress = null;
            }
            this.state = State.CLOSED;
            ChannelPromise channelPromise = this.connectPromise;
            if (channelPromise != null) {
                channelPromise.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
                this.connectPromise = null;
            }
            if (this.writeInProgress && localChannel != null) {
                this.finishPeerRead(localChannel);
            }
        }
        if (localChannel != null && localChannel.isActive()) {
            if (localChannel.eventLoop().inEventLoop() && !this.registerInProgress) {
                this.doPeerClose(localChannel, localChannel.writeInProgress);
            } else {
                final boolean bl = localChannel.writeInProgress;
                try {
                    localChannel.eventLoop().execute(new Runnable(){

                        @Override
                        public void run() {
                            LocalChannel.this.doPeerClose(localChannel, bl);
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    this.releaseInboundBuffers();
                    throw runtimeException;
                }
            }
            this.peer = null;
        }
    }

    private void doPeerClose(LocalChannel localChannel, boolean bl) {
        if (bl) {
            this.finishPeerRead0(this);
        }
        localChannel.unsafe().close(localChannel.unsafe().voidPromise());
    }

    @Override
    protected void doDeregister() throws Exception {
        ((SingleThreadEventExecutor)((Object)this.eventLoop())).removeShutdownHook(this.shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBeginRead() throws Exception {
        if (this.readInProgress) {
            return;
        }
        ChannelPipeline channelPipeline = this.pipeline();
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        Integer n = internalThreadLocalMap.localChannelReaderStackDepth();
        if (n < 8) {
            internalThreadLocalMap.setLocalChannelReaderStackDepth(n + 1);
            try {
                Object object;
                while ((object = queue.poll()) != null) {
                    channelPipeline.fireChannelRead(object);
                }
                channelPipeline.fireChannelReadComplete();
            }
            finally {
                internalThreadLocalMap.setLocalChannelReaderStackDepth(n);
            }
        }
        try {
            this.eventLoop().execute(this.readTask);
        }
        catch (RuntimeException runtimeException) {
            this.releaseInboundBuffers();
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        LocalChannel localChannel;
        block13: {
            switch (this.state) {
                case OPEN: 
                case BOUND: {
                    throw new NotYetConnectedException();
                }
                case CLOSED: {
                    throw DO_WRITE_CLOSED_CHANNEL_EXCEPTION;
                }
            }
            localChannel = this.peer;
            this.writeInProgress = true;
            block9: while (true) {
                while (true) {
                    Object object;
                    if ((object = channelOutboundBuffer.current()) == null) {
                        break block13;
                    }
                    try {
                        if (localChannel.state == State.CONNECTED) {
                            localChannel.inboundBuffer.add(ReferenceCountUtil.retain(object));
                            channelOutboundBuffer.remove();
                            continue block9;
                        }
                        channelOutboundBuffer.remove(DO_WRITE_CLOSED_CHANNEL_EXCEPTION);
                        continue block9;
                    }
                    catch (Throwable throwable) {
                        channelOutboundBuffer.remove(throwable);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.writeInProgress = false;
            }
        }
        this.finishPeerRead(localChannel);
    }

    private void finishPeerRead(LocalChannel localChannel) {
        if (localChannel.eventLoop() == this.eventLoop() && !localChannel.writeInProgress) {
            this.finishPeerRead0(localChannel);
        } else {
            this.runFinishPeerReadTask(localChannel);
        }
    }

    private void runFinishPeerReadTask(final LocalChannel localChannel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LocalChannel.this.finishPeerRead0(localChannel);
            }
        };
        try {
            if (localChannel.writeInProgress) {
                localChannel.finishReadFuture = localChannel.eventLoop().submit(runnable);
            } else {
                localChannel.eventLoop().execute(runnable);
            }
        }
        catch (RuntimeException runtimeException) {
            localChannel.releaseInboundBuffers();
            throw runtimeException;
        }
    }

    private void releaseInboundBuffers() {
        Object object;
        while ((object = this.inboundBuffer.poll()) != null) {
            ReferenceCountUtil.release(object);
        }
    }

    private void finishPeerRead0(LocalChannel localChannel) {
        Future<?> future = localChannel.finishReadFuture;
        if (future != null) {
            if (!future.isDone()) {
                this.runFinishPeerReadTask(localChannel);
                return;
            }
            FINISH_READ_FUTURE_UPDATER.compareAndSet(localChannel, future, null);
        }
        ChannelPipeline channelPipeline = localChannel.pipeline();
        if (localChannel.readInProgress) {
            Object object;
            localChannel.readInProgress = false;
            while ((object = localChannel.inboundBuffer.poll()) != null) {
                channelPipeline.fireChannelRead(object);
            }
            channelPipeline.fireChannelReadComplete();
        }
    }

    static {
        METADATA = new ChannelMetadata(false);
        DO_WRITE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), LocalChannel.class, "doWrite(...)");
        DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), LocalChannel.class, "doClose()");
        AtomicReferenceFieldUpdater<LocalChannel, Object> atomicReferenceFieldUpdater = PlatformDependent.newAtomicReferenceFieldUpdater(LocalChannel.class, "finishReadFuture");
        if (atomicReferenceFieldUpdater == null) {
            atomicReferenceFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(LocalChannel.class, Future.class, "finishReadFuture");
        }
        FINISH_READ_FUTURE_UPDATER = atomicReferenceFieldUpdater;
    }

    private class LocalUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private LocalUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            Channel channel;
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            if (LocalChannel.this.state == State.CONNECTED) {
                AlreadyConnectedException alreadyConnectedException = new AlreadyConnectedException();
                this.safeSetFailure(channelPromise, alreadyConnectedException);
                LocalChannel.this.pipeline().fireExceptionCaught(alreadyConnectedException);
                return;
            }
            if (LocalChannel.this.connectPromise != null) {
                throw new ConnectionPendingException();
            }
            LocalChannel.this.connectPromise = channelPromise;
            if (LocalChannel.this.state != State.BOUND && socketAddress2 == null) {
                socketAddress2 = new LocalAddress(LocalChannel.this);
            }
            if (socketAddress2 != null) {
                try {
                    LocalChannel.this.doBind(socketAddress2);
                }
                catch (Throwable throwable) {
                    this.safeSetFailure(channelPromise, throwable);
                    this.close(this.voidPromise());
                    return;
                }
            }
            if (!((channel = LocalChannelRegistry.get(socketAddress)) instanceof LocalServerChannel)) {
                ConnectException connectException = new ConnectException("connection refused: " + socketAddress);
                this.safeSetFailure(channelPromise, connectException);
                this.close(this.voidPromise());
                return;
            }
            LocalServerChannel localServerChannel = (LocalServerChannel)channel;
            LocalChannel.this.peer = localServerChannel.serve(LocalChannel.this);
        }
    }

    private static enum State {
        OPEN,
        BOUND,
        CONNECTED,
        CLOSED;

    }
}

