/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.scc.dei.ecplean;

import edu.kit.scc.dei.ecplean.ECPAuthenticationException;
import edu.kit.scc.dei.ecplean.ECPAuthenticationInfo;
import edu.kit.scc.dei.ecplean.ECPUnauthorizedException;
import edu.kit.scc.dei.ecplean.NamespaceResolver;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ECPAuthenticatorBase
extends Observable {
    protected static Logger LOG = Logger.getLogger(ECPAuthenticatorBase.class.getName());
    protected ECPAuthenticationInfo authInfo;
    protected HttpClientBuilder clientBuilder;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected HttpClient client;
    protected XPathFactory xpathFactory;
    protected NamespaceResolver namespaceResolver;
    protected TransformerFactory transformerFactory;

    public ECPAuthenticatorBase(HttpClientBuilder httpClientBuilder) {
        this.clientBuilder = httpClientBuilder;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.xpathFactory = XPathFactory.newInstance();
        this.namespaceResolver = new NamespaceResolver();
        this.namespaceResolver.addNamespace("ecp", "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        this.namespaceResolver.addNamespace("S", "http://schemas.xmlsoap.org/soap/envelope/");
        this.namespaceResolver.addNamespace("paos", "urn:liberty:paos:2003-08");
        this.transformerFactory = TransformerFactory.newInstance();
    }

    protected Document authenticateIdP(Document document) throws ECPAuthenticationException {
        HttpResponse httpResponse;
        String string;
        if (this.isFine()) {
            LOG.fine("Sending initial IdP Request to " + this.authInfo.getIdpEcpEndpoint());
        }
        HttpPost httpPost = new HttpPost(this.authInfo.getIdpEcpEndpoint().toString());
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.authInfo.getUsername(), this.authInfo.getPassword()));
        httpPost.setHeader("Content-Type", "text/xml; charset=UTF-8");
        HttpHost httpHost = new HttpHost(this.authInfo.getIdpEcpEndpoint().getHost(), this.authInfo.getIdpEcpEndpoint().getPort(), this.authInfo.getIdpEcpEndpoint().getScheme());
        BasicAuthCache basicAuthCache = new BasicAuthCache();
        BasicScheme basicScheme = new BasicScheme(Consts.UTF_8);
        basicAuthCache.put(httpHost, basicScheme);
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setCredentialsProvider(basicCredentialsProvider);
        httpClientContext.setAuthCache(basicAuthCache);
        try {
            string = this.documentToString(document);
            httpPost.setEntity(new StringEntity(string));
            httpResponse = this.getHttpClientForIDP().execute(httpHost, (HttpRequest)httpPost, (HttpContext)httpClientContext);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new ECPUnauthorizedException("User not authorized: " + httpResponse);
            }
        }
        catch (IOException | TransformerException exception) {
            LOG.warning("Could not submit PAOS request to IdP. " + exception);
            throw new ECPAuthenticationException(exception);
        }
        try {
            string = EntityUtils.toString(httpResponse.getEntity());
            return this.buildDocumentFromString(string);
        }
        catch (IOException | ParserConfigurationException | ParseException | SAXException exception) {
            LOG.warning("Could not read response from IdP" + exception);
            throw new ECPAuthenticationException(exception);
        }
    }

    protected Document buildDocumentFromString(String string) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(string)));
    }

    protected Object queryDocument(Document document, String string, QName qName) throws XPathException {
        XPath xPath = this.xpathFactory.newXPath();
        xPath.setNamespaceContext(this.namespaceResolver);
        XPathExpression xPathExpression = xPath.compile(string);
        return xPathExpression.evaluate(document, qName);
    }

    protected String documentToString(Document document) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
        return streamResult.getWriter().toString();
    }

    protected synchronized HttpClient getHttpClient() {
        if (this.client == null && this.authInfo != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            HttpHost httpHost = new HttpHost(this.authInfo.getIdpEcpEndpoint().getHost(), this.authInfo.getIdpEcpEndpoint().getPort());
            basicCredentialsProvider.setCredentials(new AuthScope(httpHost), new UsernamePasswordCredentials(this.authInfo.getUsername(), this.authInfo.getPassword()));
            String string = System.getProperty("http.proxyHost");
            if (string != null && !string.trim().isEmpty()) {
                int n = Integer.parseInt(System.getProperty("http.proxyPort"));
                HttpHost httpHost2 = new HttpHost(string, n);
                this.clientBuilder.setProxy(httpHost2);
                if (this.authInfo.getProxyUsername() != null && !this.authInfo.getProxyUsername().isEmpty()) {
                    UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.authInfo.getProxyUsername(), this.authInfo.getProxyPassword());
                    AuthScope authScope = new AuthScope(httpHost2);
                    basicCredentialsProvider.setCredentials(authScope, usernamePasswordCredentials);
                }
            }
            this.clientBuilder.setDefaultCredentialsProvider(basicCredentialsProvider);
            this.client = this.clientBuilder.build();
        }
        return this.client;
    }

    protected HttpClient getHttpClientForIDP() {
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        String string = System.getProperty("https.proxyHost");
        List<Proxy> list = ProxySelector.getDefault().select(this.authInfo.getIdpEcpEndpoint());
        if (list.isEmpty() || list.get(0).type() == Proxy.Type.DIRECT) {
            string = null;
        }
        HttpHost httpHost = new HttpHost(this.authInfo.getIdpEcpEndpoint().getHost(), this.authInfo.getIdpEcpEndpoint().getPort());
        basicCredentialsProvider.setCredentials(new AuthScope(httpHost), new UsernamePasswordCredentials(this.authInfo.getUsername(), this.authInfo.getPassword()));
        if (string != null && !string.trim().isEmpty()) {
            int n = Integer.parseInt(System.getProperty("http.proxyPort"));
            HttpHost httpHost2 = new HttpHost(string, n);
            httpClientBuilder.setProxy(httpHost2);
            if (this.authInfo.getProxyUsername() != null && !this.authInfo.getProxyUsername().isEmpty()) {
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.authInfo.getProxyUsername(), this.authInfo.getProxyPassword());
                AuthScope authScope = new AuthScope(httpHost2);
                basicCredentialsProvider.setCredentials(authScope, usernamePasswordCredentials);
            }
        } else {
            httpClientBuilder.setProxy(null);
        }
        httpClientBuilder.setDefaultCredentialsProvider(basicCredentialsProvider);
        return httpClientBuilder.build();
    }

    protected boolean isFine() {
        return LOG.isLoggable(Level.FINE);
    }

    protected boolean isInfo() {
        return LOG.isLoggable(Level.INFO);
    }
}

