/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import java.awt.Component;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTableCellRenderer
implements TableCellRenderer {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    protected TableCellRenderer delegate;
    protected HashMap<String, TableCellRenderer> renderers = new HashMap();
    private Object numberFormat = NumberFormat.getInstance();
    private Object dateFormat = DateFormat.getInstance();

    public ObjectTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this.delegate = tableCellRenderer;
    }

    public void addRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        this.renderers.put(this.getRendererKey(clazz), tableCellRenderer);
    }

    public void removeRenderer(Class<?> clazz) {
        this.renderers.remove(this.getRendererKey(clazz));
    }

    public TableCellRenderer getRenderer(Class<?> clazz) {
        return this.renderers.get(this.getRendererKey(clazz));
    }

    public void addRenderer(int n, int n2, TableCellRenderer tableCellRenderer) {
        this.renderers.put(this.getRendererKey(n, n2), tableCellRenderer);
    }

    public void removeRenderer(int n, int n2) {
        this.renderers.remove(this.getRendererKey(n, n2));
    }

    public TableCellRenderer getRenderer(int n, int n2) {
        return this.renderers.get(this.getRendererKey(n, n2));
    }

    private String getRendererKey(Class<?> clazz) {
        return this.getRendererKey(clazz, -1, -1);
    }

    private String getRendererKey(int n, int n2) {
        return this.getRendererKey(null, n, n2);
    }

    private String getRendererKey(Class<?> clazz, int n, int n2) {
        return clazz + "/" + n + "/" + n2;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TableCellRenderer tableCellRenderer = this.getRenderer(JAVA5 ? n : jTable.convertRowIndexToModel(n), jTable.convertColumnIndexToModel(n2));
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getRenderer(object == null ? Object.class : object.getClass());
        }
        if (tableCellRenderer == null) {
            TableCellRenderer tableCellRenderer2 = tableCellRenderer = object == null ? null : this.getRenderer(object.getClass().getSuperclass());
        }
        if (tableCellRenderer != null) {
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (component instanceof JLabel) {
            this.configureValue((JLabel)component, object);
        }
        return component;
    }

    private void configureValue(JLabel jLabel, Object object) {
        if (object instanceof Number) {
            jLabel.setHorizontalAlignment(11);
            if (object instanceof Float || object instanceof Double) {
                jLabel.setText(object == null ? "" : ((NumberFormat)this.numberFormat).format(object));
            }
        } else if (object instanceof Icon) {
            jLabel.setHorizontalAlignment(0);
            jLabel.setIcon((Icon)object);
            jLabel.setText("");
        } else if (object instanceof Date) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance();
            }
            jLabel.setHorizontalAlignment(10);
            jLabel.setText(object == null ? "" : ((Format)this.dateFormat).format(object));
        }
    }
}

