/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.pattern;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.pattern.AbstractPattern;

public class EndMatchPattern
extends AbstractPattern {
    private char[] matchLower;
    private char[] matchUpper;

    public EndMatchPattern(String string) {
        super(string);
        Reject.ifFalse(string.lastIndexOf("*") == 0, "Pattern must start with * and should not contain any other stars");
        this.matchLower = this.getPatternText().replaceAll("\\*", "").toLowerCase().toCharArray();
        this.matchUpper = this.getPatternText().replaceAll("\\*", "").toUpperCase().toCharArray();
    }

    @Override
    public boolean isMatch(String string) {
        int n = string.length() - 1;
        if (n == -1) {
            return this.matchLower.length == 0;
        }
        if (string.length() < this.matchLower.length) {
            return false;
        }
        for (int i = this.matchLower.length - 1; i >= 0; --i) {
            char c = string.charAt(n);
            if (!EndMatchPattern.equalChar(c, this.matchLower[i], this.matchUpper[i])) {
                return false;
            }
            --n;
        }
        return true;
    }
}

