/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os;

import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.IOException;
import java.util.logging.Logger;

public class SystemUtil {
    private static final Logger log = Logger.getLogger(SystemUtil.class.getName());

    public static boolean shutdown(String string) {
        if (OSUtil.isWindowsSystem()) {
            try {
                Process process = Runtime.getRuntime().exec("shutdown -s");
                process.getOutputStream();
                process.waitFor();
                return true;
            }
            catch (InterruptedException interruptedException) {
                log.severe(interruptedException.getMessage());
            }
            catch (IOException iOException) {
                log.severe(iOException.getMessage());
            }
        } else if (OSUtil.isLinux()) {
            try {
                String[] stringArray = new String[]{"bash", "-c", "echo " + string + " | sudo -S shutdown -P +1", "&"};
                Runtime.getRuntime().exec(stringArray);
                return true;
            }
            catch (IOException iOException) {
                log.severe(iOException.getMessage());
            }
        }
        return false;
    }

    public static boolean isShutdownSupported() {
        return OSUtil.isWindowsSystem() || OSUtil.isLinux();
    }
}

