/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import de.dal33t.powerfolder.util.os.mac.MacUtils;
import java.awt.SystemTray;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class OSUtil {
    private static final Logger log = Logger.getLogger(OSUtil.class.getName());
    private static Boolean sysTraySupport;
    private static Boolean windows;

    private OSUtil() {
    }

    public static boolean isWindowsSystem() {
        if (windows == null) {
            String string = System.getProperty("os.name");
            windows = string != null && string.toLowerCase().indexOf("windows") >= 0;
        }
        return windows;
    }

    public static boolean isWindowsVistaSystem() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().indexOf("windows vista") >= 0;
    }

    public static boolean isWindows7System() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().indexOf("windows 7") >= 0;
    }

    public static boolean isWindowsXPSystem() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().indexOf("windows xp") >= 0;
    }

    public static boolean isAnroidSystem() {
        String string = System.getProperty("java.vendor");
        return string != null && string.toLowerCase().indexOf("android") >= 0;
    }

    public static boolean isWindowsMEorOlder() {
        String string = System.getProperty("os.name");
        return string.endsWith("Me") || string.endsWith("98") || string.endsWith("95");
    }

    public static boolean isMacOS() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("mac");
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().indexOf("linux") != -1;
    }

    public static boolean is64BitPlatform() {
        String string = System.getProperty("sun.arch.data.model");
        if (string != null) {
            return string.contains("64");
        }
        return System.getProperty("os.arch").contains("64");
    }

    public static boolean isWebStart() {
        return !System.getProperty("using.webstart", "false").equals("false");
    }

    public static boolean isSystemService() {
        return System.getProperty("systemservice", "false").equalsIgnoreCase("true");
    }

    public static boolean isJETRuntime() {
        return System.getProperty("java.vm.name", "Oracle VM").toLowerCase().contains("jet");
    }

    public static boolean isSystraySupported() {
        if (sysTraySupport == null) {
            sysTraySupport = SystemTray.isSupported();
        }
        return sysTraySupport;
    }

    public static boolean isStartupItemSupported() {
        return OSUtil.isWindowsSystem() || OSUtil.isMacOS();
    }

    public static boolean hasPFStartup(Controller controller) throws UnsupportedOperationException {
        if (OSUtil.isWindowsSystem() && WinUtils.isSupported()) {
            return WinUtils.getInstance().hasPFStartup(controller);
        }
        if (OSUtil.isMacOS() && MacUtils.isSupported()) {
            return MacUtils.getInstance().hasPFStartup(controller);
        }
        throw new UnsupportedOperationException("This platform does not support start up items");
    }

    public static void setPFStartup(boolean bl, Controller controller) throws IOException, UnsupportedOperationException {
        if (OSUtil.isWindowsSystem()) {
            WinUtils.getInstance().setPFStartup(bl, controller);
            return;
        }
        if (OSUtil.isMacOS()) {
            MacUtils.getInstance().setPFStartup(bl, controller);
            return;
        }
        throw new UnsupportedOperationException("This platform does not support start up items");
    }

    public static void disableSystray() {
        sysTraySupport = false;
    }

    private static boolean loadLibrary(Class<?> clazz, String string, boolean bl, boolean bl2) {
        try {
            log.finer(clazz.getName() + " --> Loading library: " + string);
            if (bl) {
                System.load(string);
            } else {
                System.loadLibrary(string);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (bl2) {
                log.log(Level.FINER, "UnsatisfiedLinkError. " + unsatisfiedLinkError);
            } else {
                log.log(Level.WARNING, "UnsatisfiedLinkError. " + unsatisfiedLinkError);
            }
            return false;
        }
    }

    public static boolean loadLibrary(Class<?> clazz, String string) {
        Path path;
        String string2 = "";
        if (OSUtil.isWindowsSystem()) {
            string2 = OSUtil.is64BitPlatform() ? "win64libs" : "win32libs";
        } else if (OSUtil.isLinux()) {
            string2 = OSUtil.is64BitPlatform() ? "lin64libs" : "lin32libs";
        } else if (OSUtil.isMacOS()) {
            string2 = "mac64libs";
        }
        String string3 = System.mapLibraryName(string);
        Path path2 = null;
        int n = 0;
        do {
            Object object = string;
            if (n > 0) {
                object = (String)object + "-" + n;
            }
            String string4 = System.mapLibraryName((String)object);
            path2 = Controller.getTempFilesLocation().resolve(string4);
            path2.toFile().deleteOnExit();
            boolean bl = n != 1;
            path = Util.copyResourceTo(string3, string2, path2, false, bl);
            if (OSUtil.loadLibrary(clazz, string, false, true)) {
                return true;
            }
            if (path == null) continue;
            try {
                if (OSUtil.loadLibrary(clazz, path.toAbsolutePath().toString(), true, bl)) {
                    return true;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                log.warning("Unable to load library " + string + ": " + unsatisfiedLinkError);
            }
        } while (++n < 5);
        if (path == null) {
            log.warning(clazz.getName() + " --> Completely failed to load " + string + ": Failed to copy resource to " + path2);
            return false;
        }
        log.warning(clazz.getName() + " --> Completely failed to load " + string + " - see error above!");
        return false;
    }

    public static boolean configureTruststore() {
        Logger logger = Logger.getLogger(OSUtil.class.getName());
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            KeyStore keyStore = null;
            try {
                if (OSUtil.isWindowsSystem()) {
                    logger.fine("Loading Windows-ROOT trust store");
                    keyStore = KeyStore.getInstance("Windows-ROOT");
                    keyStore.load(null, null);
                } else if (OSUtil.isMacOS()) {
                    logger.fine("Loading macOS KeychainStore");
                    keyStore = KeyStore.getInstance("KeychainStore");
                    keyStore.load(null, null);
                }
            }
            catch (Exception exception) {
                logger.info("Could not load OS trust store: " + exception);
                keyStore = null;
            }
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(null, null);
            if (keyStore != null) {
                for (String object2 : Collections.list(keyStore.aliases())) {
                    keyStore2.setCertificateEntry(object2, keyStore.getCertificate(object2));
                }
            }
            int n = 0;
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                    String string;
                    if (keyStore2.containsAlias(string = "jdk-" + n++)) continue;
                    keyStore2.setCertificateEntry(string, x509Certificate);
                }
            }
            TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory2.init(keyStore2);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerFactory2.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            return true;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unable to configure combined truststore. " + exception, exception);
            return false;
        }
    }
}

