/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NetworkUtil {
    private static final Logger LOG = Logger.getLogger(NetworkUtil.class.getName());
    public static String LOOPBACK_LOCALHOST_IPv4 = "127.0.0.1";
    private static final long CACHE_TIMEOUT = 30000L;
    private static long LAST_CHACHE_UPDATE = 0L;
    private static Map<InterfaceAddress, NetworkInterface> LOCAL_NETWORK_ADDRESSES_CACHE;
    private static InetAddress NULL_IP;

    private NetworkUtil() {
    }

    public static void setupSocket(Socket socket, Controller controller) throws SocketException {
        Reject.ifNull(socket, "Socket is null");
        Reject.ifNull(controller, "Controller is null");
        boolean bl = NetworkUtil.isOnLanOrLoopback(socket.getInetAddress());
        if (bl) {
            int n = ConfigurationEntry.NET_SOCKET_LAN_BUFFER_SIZE.getValueInt(controller);
            if (n > 0) {
                socket.setReceiveBufferSize(n);
                socket.setSendBufferSize(n);
            }
        } else {
            int n = ConfigurationEntry.NET_SOCKET_INTERNET_BUFFER_SIZE.getValueInt(controller);
            if (n > 0) {
                socket.setReceiveBufferSize(n);
                socket.setSendBufferSize(n);
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Socket setup: (" + socket.getSendBufferSize() + "/" + socket.getReceiveBufferSize() + "/" + socket.getSoLinger() + "ms) " + socket);
        }
    }

    public static void setupSocket(UDTSocket uDTSocket, InetSocketAddress inetSocketAddress, Controller controller) throws IOException {
        boolean bl;
        Reject.ifNull(uDTSocket, "Socket is null");
        Reject.ifNull(controller, "Controller is null");
        boolean bl2 = bl = inetSocketAddress != null && inetSocketAddress.getAddress() != null ? NetworkUtil.isOnLanOrLoopback(inetSocketAddress.getAddress()) : false;
        if (bl) {
            int n;
            int n2 = ConfigurationEntry.NET_SOCKET_LAN_BUFFER_SIZE.getValueInt(controller);
            if (n2 > 0) {
                uDTSocket.setSoUDPReceiverBufferSize(n2);
                uDTSocket.setSoUDPSenderBufferSize(n2);
            }
            if ((n = ConfigurationEntry.NET_SOCKET_LAN_BUFFER_LIMIT.getValueInt(controller).intValue()) > 0) {
                uDTSocket.setSoSenderBufferLimit(n);
                uDTSocket.setSoReceiverBufferLimit(n);
            }
        } else {
            int n;
            int n3 = ConfigurationEntry.NET_SOCKET_INTERNET_BUFFER_SIZE.getValueInt(controller);
            if (n3 > 0) {
                uDTSocket.setSoUDPReceiverBufferSize(n3);
                uDTSocket.setSoUDPSenderBufferSize(n3);
            }
            if ((n = ConfigurationEntry.NET_SOCKET_INTERNET_BUFFER_LIMIT.getValueInt(controller).intValue()) > 0) {
                uDTSocket.setSoSenderBufferLimit(n);
                uDTSocket.setSoReceiverBufferLimit(n);
            }
        }
        LOG.finer("Socket setup: (" + uDTSocket.getSoUDPSenderBufferSize() + "/" + uDTSocket.getSoUDPReceiverBufferSize() + " " + uDTSocket);
    }

    public static boolean isOnLanOrLoopback(InetAddress inetAddress) {
        Reject.ifNull(inetAddress, "Address is null");
        if (!(inetAddress instanceof Inet4Address)) {
            LOG.warning("Inet6 not supported yet: " + inetAddress);
        }
        try {
            boolean bl;
            boolean bl2 = bl = inetAddress.isLoopbackAddress() || NetworkUtil.isFromThisComputer(inetAddress);
            if (bl) {
                return true;
            }
            for (InterfaceAddress interfaceAddress : NetworkUtil.getAllLocalNetworkAddressesCached().keySet()) {
                if (!(interfaceAddress.getAddress() instanceof Inet4Address) || !NetworkUtil.isOnInterfaceSubnet(interfaceAddress, inetAddress)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            LOG.warning("Unable to check network setup: " + exception);
            return false;
        }
    }

    public static final Map<InterfaceAddress, NetworkInterface> getAllLocalNetworkAddresses() throws SocketException {
        HashMap<InterfaceAddress, NetworkInterface> hashMap = new HashMap<InterfaceAddress, NetworkInterface>();
        NetworkInterface networkInterface = null;
        InterfaceAddress interfaceAddress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                networkInterface = enumeration.nextElement();
                for (InterfaceAddress interfaceAddress2 : networkInterface.getInterfaceAddresses()) {
                    try {
                        interfaceAddress = interfaceAddress2;
                        if (interfaceAddress == null) continue;
                        hashMap.put(interfaceAddress, networkInterface);
                    }
                    catch (Throwable throwable) {
                        LOG.warning("Unable to get network interface configuration of " + networkInterface + " address: " + interfaceAddress + ": " + throwable);
                    }
                }
            }
        }
        catch (Error error) {
            LOG.warning("Unable to get network interface configuration of " + networkInterface + " address: " + interfaceAddress + ": " + error);
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOnInterfaceSubnet(InterfaceAddress interfaceAddress, InetAddress inetAddress) {
        Reject.ifNull(inetAddress, "Address");
        Reject.ifNull(interfaceAddress, "InterfaceAddress");
        try {
            int n;
            if (!(interfaceAddress.getAddress() instanceof Inet4Address)) return false;
            if (!(inetAddress instanceof Inet4Address)) {
                return false;
            }
            byte[] byArray = interfaceAddress.getAddress().getAddress();
            int n2 = (byArray[0] << 24) + (byArray[1] << 16) + (byArray[2] << 8) + (byArray[3] & 0xFF);
            int n3 = 0;
            int n4 = interfaceAddress.getNetworkPrefixLength();
            if (n4 > 32) {
                if (interfaceAddress.getAddress().isSiteLocalAddress()) {
                    n4 = 24;
                } else if (interfaceAddress.getAddress().isLinkLocalAddress()) {
                    n4 = 16;
                } else {
                    if (!interfaceAddress.getAddress().isLoopbackAddress()) return false;
                    n4 = 8;
                }
            } else if (n4 <= 0) {
                if (!interfaceAddress.getAddress().isLoopbackAddress()) return false;
                n4 = 8;
            }
            for (n = 0; n < n4; ++n) {
                int n5 = 1 << 31 - n;
                n3 += n5;
            }
            n = n2 & n3;
            byte[] byArray2 = inetAddress.getAddress();
            int n6 = (byArray2[0] << 24) + (byArray2[1] << 16) + (byArray2[2] << 8) + (byArray2[3] & 0xFF);
            int n7 = n6 & n3;
            if (n7 != n) return false;
            return true;
        }
        catch (Exception exception) {
            LOG.severe("Prolbem while checking subnet mask. " + exception);
            return false;
        }
    }

    public static boolean isFromThisComputer(InetAddress inetAddress) throws SocketException {
        try {
            if (inetAddress == null) {
                return false;
            }
            if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) {
                return true;
            }
            for (InterfaceAddress interfaceAddress : NetworkUtil.getAllLocalNetworkAddressesCached().keySet()) {
                if (interfaceAddress == null || interfaceAddress.getAddress() == null || !interfaceAddress.getAddress().equals(inetAddress)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            LOG.severe("Unable to get network setup. " + exception);
        }
        return false;
    }

    public static final Map<InterfaceAddress, NetworkInterface> getAllLocalNetworkAddressesCached() throws SocketException {
        boolean bl;
        boolean bl2 = bl = LOCAL_NETWORK_ADDRESSES_CACHE == null || System.currentTimeMillis() - 30000L > LAST_CHACHE_UPDATE;
        if (bl) {
            LOCAL_NETWORK_ADDRESSES_CACHE = NetworkUtil.getAllLocalNetworkAddresses();
            LAST_CHACHE_UPDATE = System.currentTimeMillis();
        }
        return LOCAL_NETWORK_ADDRESSES_CACHE;
    }

    public static final boolean isUDTSupported() {
        return UDTSocket.isSupported();
    }

    public static final boolean isNullIP(InetAddress inetAddress) {
        byte[] byArray;
        Reject.ifNull(inetAddress, "Address is null");
        boolean bl = false;
        bl = NULL_IP != null ? Boolean.valueOf(NULL_IP.equals(inetAddress)).booleanValue() : Boolean.valueOf(((byArray = inetAddress.getAddress())[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 0 && (byArray[2] & 0xFF) == 0 && (byArray[3] & 0xFF) == 0).booleanValue();
        return bl;
    }

    public static final String getHostAddressNoResolve(InetAddress inetAddress) {
        Reject.ifNull(inetAddress, "Address is null");
        try {
            String[] stringArray = inetAddress.toString().split("/");
            if (StringUtils.isNotBlank(stringArray[0])) {
                return stringArray[0];
            }
            if (StringUtils.isNotBlank(stringArray[1])) {
                return stringArray[1];
            }
        }
        catch (Exception exception) {
            LOG.warning("Unable to resolve hostname/ip from " + inetAddress + ". " + exception);
        }
        return inetAddress.getHostAddress();
    }

    public static final void installAllTrustingSSLManager() {
        try {
            LOG.warning("Any certificate will be trusted for SSL connections");
            TrustManager[] trustManagerArray = new TrustManager[]{new AllTrustingSSLManager()};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            System.setProperty("jsse.enableSNIExtension", "false");
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            NULL_IP = InetAddress.getByAddress("0.0.0.0", new byte[]{0, 0, 0, 0});
        }
        catch (UnknownHostException unknownHostException) {
            NULL_IP = null;
            unknownHostException.printStackTrace();
        }
    }

    public static final class AllTrustingSSLManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

