/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.intern;

import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.util.StackDump;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.intern.Internalizer;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderInfoInternalizer
implements Internalizer<FolderInfo> {
    private static final Logger LOG = Logger.getLogger(FolderInfoInternalizer.class.getName());
    private final Map<FolderInfo, FolderInfo> INSTANCES = new WeakHashMap<FolderInfo, FolderInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderInfo intern(FolderInfo folderInfo) {
        FolderInfo folderInfo2;
        if (folderInfo == null) {
            return null;
        }
        Map<FolderInfo, FolderInfo> map = this.INSTANCES;
        synchronized (map) {
            folderInfo2 = this.INSTANCES.get(folderInfo);
        }
        if (folderInfo2 != null) {
            return folderInfo2;
        }
        if (folderInfo.isLookupInstance()) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, folderInfo + ": Not internalizing lookup instance", new StackDump());
            return folderInfo;
        }
        map = this.INSTANCES;
        synchronized (map) {
            folderInfo2 = this.INSTANCES.get(folderInfo);
            if (folderInfo2 == null) {
                if (StringUtils.isBlank(folderInfo.getName())) {
                    return folderInfo;
                }
                this.INSTANCES.put(folderInfo, folderInfo);
                folderInfo2 = folderInfo;
            }
        }
        return folderInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FolderInfo rename(FolderInfo folderInfo) {
        if (folderInfo == null) {
            return null;
        }
        Map<FolderInfo, FolderInfo> map = this.INSTANCES;
        synchronized (map) {
            FolderInfo folderInfo2 = this.INSTANCES.get(folderInfo);
            if (folderInfo2 != null && folderInfo2.getName().equals(folderInfo.getName()) && folderInfo2.getVersion() == folderInfo.getVersion()) {
                return folderInfo2;
            }
            if (folderInfo.isLookupInstance()) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, folderInfo + ": Renaming from lookup instance", new StackDump());
                folderInfo = FolderInfoFactory.unmarshallExistingFolder(folderInfo2.getId(), folderInfo.getName(), folderInfo2.getVersion(), folderInfo2.getParent());
            }
            if (folderInfo2 != null && !folderInfo.isMetaFolder()) {
                LOG.log(Level.INFO, folderInfo + ": rename (forced internalize). old: " + folderInfo2);
            }
            this.INSTANCES.put(folderInfo, folderInfo);
        }
        return folderInfo;
    }
}

