/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import de.dal33t.powerfolder.util.RingBuffer;
import de.dal33t.powerfolder.util.delta.RollingChecksum;

public final class RollingAdler32
implements RollingChecksum {
    private static final int MOD_ADLER = 65521;
    private final RingBuffer rbuf;
    private final int n;
    private int A = 1;
    private int B;

    public RollingAdler32(int n) {
        this.rbuf = new RingBuffer(n);
        this.n = n;
    }

    @Override
    public void update(int n) {
        int n2 = 0;
        n &= 0xFF;
        if (this.rbuf.remaining() == 0) {
            n2 = this.rbuf.read();
            --this.B;
        }
        this.rbuf.write(n);
        this.A = this.A + n - n2;
        if (this.A < 0) {
            this.A += 65521;
        } else if (this.A >= 65521) {
            this.A -= 65521;
        }
        this.B = (this.B + this.A - this.n * n2) % 65521;
        if (this.B < 0) {
            this.B += 65521;
        }
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public void reset() {
        this.A = 1;
        this.B = 0;
        this.rbuf.reset();
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Offset is negative");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Length is negative");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Offset + length too large!");
        }
        while (n2 > 0) {
            this.update(byArray[n++]);
            --n2;
        }
    }

    @Override
    public int getFrameSize() {
        return this.n;
    }

    @Override
    public long getValue() {
        return (long)this.B << 16 | (long)this.A;
    }
}

