/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.delta;

import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.RingBuffer;
import de.dal33t.powerfolder.util.delta.MatchInfo;
import de.dal33t.powerfolder.util.delta.PartInfo;
import de.dal33t.powerfolder.util.delta.RollingChecksum;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PartInfoMatcher
extends FilterInputStream {
    private static final int BUFFER_SIZE = 16384;
    private final RollingChecksum chksum;
    private final MessageDigest digester;
    private final RingBuffer rbuf;
    private final byte[] buf = new byte[16384];
    private final Map<Long, List<PartInfo>> partCache = new HashMap<Long, List<PartInfo>>();
    private final byte[] dbuf;
    private long pos;

    public PartInfoMatcher(InputStream inputStream, RollingChecksum rollingChecksum, MessageDigest messageDigest, PartInfo[] partInfoArray) {
        super(inputStream);
        Reject.noNullElements(rollingChecksum, messageDigest, partInfoArray);
        this.chksum = rollingChecksum;
        this.digester = messageDigest;
        this.rbuf = new RingBuffer(rollingChecksum.getFrameSize());
        this.dbuf = new byte[rollingChecksum.getFrameSize()];
        for (PartInfo partInfo : partInfoArray) {
            List<PartInfo> list = this.partCache.get(partInfo.getChecksum());
            if (list == null) {
                list = new LinkedList<PartInfo>();
                this.partCache.put(partInfo.getChecksum(), list);
            }
            list.add(partInfo);
        }
    }

    public MatchInfo nextMatch() throws IOException, InterruptedException {
        int n;
        int n2;
        int n3;
        for (n2 = this.rbuf.remaining(); n2 > 0 && (n3 = this.read(this.buf, 0, n = Math.min(n2, 16384))) != -1; n2 -= n3) {
            this.pos += (long)n3;
            this.chksum.update(this.buf, 0, n3);
            this.rbuf.write(this.buf, 0, n3);
        }
        while (this.rbuf.remaining() == 0) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            List<PartInfo> list = this.partCache.get(this.chksum.getValue());
            if (list != null) {
                this.rbuf.peek(this.dbuf, 0, this.chksum.getFrameSize());
                byte[] byArray = this.digester.digest(this.dbuf);
                for (PartInfo object : list) {
                    if (!Arrays.equals(byArray, object.getDigest())) continue;
                    MatchInfo partInfo = new MatchInfo(object, this.pos - (long)this.chksum.getFrameSize());
                    this.rbuf.reset();
                    return partInfo;
                }
            }
            this.rbuf.skip(1);
            n3 = this.read();
            if (n3 == -1) break;
            ++this.pos;
            this.rbuf.write(n3);
            this.chksum.update(n3);
        }
        if ((n2 = (int)(this.pos % (long)this.chksum.getFrameSize())) > 0) {
            this.pos -= (long)n2;
            n = this.rbuf.available();
            this.rbuf.peek(this.dbuf, 0, n);
            this.digester.update(this.dbuf, 0, n);
            n2 = this.chksum.getFrameSize() - n2;
            for (n3 = 0; n3 < n2; ++n3) {
                this.chksum.update(0);
                this.digester.update((byte)0);
            }
            byte[] byArray = this.digester.digest();
            List<PartInfo> list = this.partCache.get(this.chksum.getValue());
            if (list != null) {
                for (PartInfo partInfo : list) {
                    if (!Arrays.equals(byArray, partInfo.getDigest())) continue;
                    return new MatchInfo(partInfo, this.pos);
                }
            }
        }
        return null;
    }
}

