/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.db;

import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.logging.Loggable;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class InetSocketAddressUserType
extends Loggable
implements UserType {
    private static final boolean RESOLVE_HOSTNAMES = false;
    private static final int[] SQL_TYPES = new int[]{12};

    @Override
    public Object assemble(Serializable serializable, Object object) throws HibernateException {
        return serializable;
    }

    @Override
    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    @Override
    public Serializable disassemble(Object object) throws HibernateException {
        return (Serializable)object;
    }

    @Override
    public boolean equals(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    @Override
    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, Object object) throws HibernateException, SQLException {
        String string = resultSet.getString(stringArray[0]);
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String[] stringArray2 = string.split(":");
        if (stringArray2.length != 2) {
            return null;
        }
        String string2 = stringArray2[0];
        int n = Integer.valueOf(stringArray2[1]);
        return InetSocketAddress.createUnresolved(string2, n);
    }

    @Override
    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, 12);
        } else {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            if (inetSocketAddress.getAddress() == null) {
                preparedStatement.setNull(n, 12);
            } else {
                String string = NetworkUtil.getHostAddressNoResolve(inetSocketAddress.getAddress()) + ":" + inetSocketAddress.getPort();
                preparedStatement.setString(n, string);
            }
        }
    }

    @Override
    public Object replace(Object object, Object object2, Object object3) throws HibernateException {
        return object;
    }

    @Override
    public Class<?> returnedClass() {
        return InetSocketAddress.class;
    }

    @Override
    public int[] sqlTypes() {
        return SQL_TYPES;
    }
}

