/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

public class Waiter {
    private long timeoutTime;
    private long waitTime;
    private boolean interrupted = false;

    public Waiter(long l) {
        this.waitTime = l;
        this.timeoutTime = System.currentTimeMillis() + l;
    }

    public long getTimoutTimeMS() {
        return this.waitTime;
    }

    public long getWaitTimeMS() {
        return System.currentTimeMillis() - this.timeoutTime + this.waitTime;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.timeoutTime || this.interrupted;
    }

    public void waitABit() {
        Waiter.waitABit(100L);
    }

    public static void waitABit(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new WaiterInterruptedException("Waiter was interrupted @ " + Thread.currentThread().getName(), interruptedException);
        }
    }

    public static void waitRandom(long l) {
        long l2 = l / 2L + (long)(Math.random() * (double)(l / 2L));
        Waiter.waitABit(l2);
    }

    public static final class WaiterInterruptedException
    extends RuntimeException {
        public WaiterInterruptedException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

