/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.d2d.D2DSocketConnectionHandler;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.util.DateUtil;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Validate;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import de.dal33t.powerfolder.util.os.LinuxUtil;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.ShellLink;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.hibernate.StaleStateException;

public class Util {
    private static boolean awtAvailable;
    private static final Logger LOG;
    private static final char[] DIGITS;

    private Util() {
    }

    public static boolean isAwtAvailable() {
        return awtAvailable;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (object == object2) {
            return true;
        }
        return object.equals(object2);
    }

    public static final boolean equalsRelativeName(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        if (string == string2) {
            return true;
        }
        if (FileInfo.IGNORE_CASE) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    public static final String toString(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    public static final char[] toCharArray(String string) {
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public static boolean isValidEmail(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        string = string.toLowerCase().trim();
        Pattern pattern = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static String getLineFeed() {
        String string = System.getProperty("line.separator");
        if (StringUtils.isNotBlank(string)) {
            return string;
        }
        if (OSUtil.isWindowsSystem()) {
            return "\r\n";
        }
        return "\n";
    }

    private static boolean allowSwarming(Controller controller, boolean bl) {
        Reject.ifNull(controller, "Controller is null");
        return ConfigurationEntry.USE_SWARMING_ON_INTERNET.getValueBoolean(controller) != false && !bl || ConfigurationEntry.USE_SWARMING_ON_LAN.getValueBoolean(controller) != false && bl;
    }

    private static boolean allowDeltaSync(Controller controller, boolean bl) {
        Reject.ifNull(controller, "Controller is null");
        return ConfigurationEntry.USE_DELTA_ON_INTERNET.getValueBoolean(controller) != false && !bl || ConfigurationEntry.USE_DELTA_ON_LAN.getValueBoolean(controller) != false && bl;
    }

    public static boolean useSwarming(Controller controller, Member member) {
        Reject.ifNull(controller, "Controller is null");
        Reject.ifNull(member, "other is null!");
        Identity identity = member.getIdentity();
        if (identity == null) {
            return false;
        }
        return identity.isSupportingPartTransfers() && Util.allowSwarming(controller, member.isOnLAN());
    }

    public static boolean useDeltaSync(Controller controller, Download download) {
        Validate.notNull(controller);
        if (download.getFile().getSize() < 51200L) {
            return false;
        }
        if (download.getPartner().getPeer() instanceof D2DSocketConnectionHandler) {
            return false;
        }
        return Util.allowDeltaSync(controller, download.getPartner().isOnLAN());
    }

    public static URL getResource(String string, String string2) {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        if (uRL == null) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string2 + "/" + string);
        }
        if (uRL == null) {
            LOG.severe("Unable to load resource " + string + ". alt location " + string2);
        }
        return uRL;
    }

    public static Path copyResourceTo(String string, String string2, Path path, boolean bl, boolean bl2) {
        Reject.ifNull(string, "Resoucse");
        try {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            if (uRL == null && string2 != null) {
                LOG.finer("Unable to find resource: " + string);
                uRL = Thread.currentThread().getContextClassLoader().getResource(string2 + "/" + string);
            }
            if (uRL == null) {
                LOG.fine("Unable to find resource: " + string2 + "/" + string);
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            long l = uRLConnection.getLastModified();
            long l2 = uRLConnection.getContentLength();
            if (!bl && Files.exists(path, new LinkOption[0])) {
                boolean bl3;
                boolean bl4 = bl3 = l2 == Files.size(path) && DateUtil.equalsFileDateCrossPlattform(l, Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
                if (bl3) {
                    LOG.fine("Not required to update " + uRL + " to " + path);
                    return path;
                }
            }
            InputStream inputStream = uRLConnection.getInputStream();
            Files.createDirectories(path, new FileAttribute[0]);
            PathUtils.copyFromStreamToFile(inputStream, path);
            Files.setLastModifiedTime(path, FileTime.fromMillis(uRLConnection.getLastModified()));
        }
        catch (IOException iOException) {
            if (bl2) {
                LOG.fine("Unable to create target for resource: " + path);
            } else {
                LOG.warning("Unable to create target for resource: " + path);
            }
            return null;
        }
        LOG.finer("created target for resource: " + path);
        return path;
    }

    public static boolean isDesktopShortcut(String string) {
        try {
            WinUtils winUtils = WinUtils.getInstance();
            if (winUtils == null) {
                return false;
            }
            Path path = Paths.get(winUtils.getSystemFolderPath(0, false), string + ".lnk");
            return Files.exists(path, new LinkOption[0]);
        }
        catch (Exception exception) {
            LOG.warning("Unable to detect desktop shortcut to: " + string + ". " + exception);
            return false;
        }
    }

    public static boolean createDesktopShortcut(String string, Path path) {
        LOG.finer("Creating desktop shortcut to " + path.toAbsolutePath());
        try {
            if (OSUtil.isLinux()) {
                Path path2 = LinuxUtil.getDesktopDirPath();
                Path path3 = Paths.get(path2.toString(), string);
                if (Files.exists(path2, new LinkOption[0]) && Files.notExists(path3, new LinkOption[0])) {
                    Files.createSymbolicLink(path3, path.toAbsolutePath(), new FileAttribute[0]);
                    return true;
                }
            } else {
                WinUtils winUtils = WinUtils.getInstance();
                if (winUtils != null) {
                    ShellLink shellLink = new ShellLink(null, string, path.toAbsolutePath().toString(), null);
                    Path path4 = Paths.get(winUtils.getSystemFolderPath(0, false), string + ".lnk");
                    winUtils.createLink(shellLink, path4.toAbsolutePath().toString());
                    return true;
                }
            }
        }
        catch (Exception exception) {
            LOG.warning("Couldn't create shortcut " + path.toAbsolutePath());
            LOG.log(Level.FINER, "IOException", exception);
        }
        return false;
    }

    public static boolean removeDesktopShortcut(String string) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Removing desktop shortcut: " + string);
        }
        Path path = null;
        try {
            if (OSUtil.isLinux()) {
                Path path2 = LinuxUtil.getDesktopDirPath();
                path = Paths.get(path2.toString(), string);
            } else {
                WinUtils winUtils = WinUtils.getInstance();
                if (winUtils != null) {
                    path = Paths.get(winUtils.getSystemFolderPath(0, false), string + ".lnk");
                }
            }
            if (null != path) {
                Files.deleteIfExists(path);
                return true;
            }
        }
        catch (Exception exception) {
            LOG.fine("Couldn't remove shortcut " + path);
            LOG.log(Level.FINER, "Exception", exception);
        }
        return false;
    }

    public static void setClipboardContents(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
    }

    public static String getClipboardContents() {
        boolean bl;
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                LOG.severe(unsupportedFlavorException.getMessage());
            }
            catch (IOException iOException) {
                LOG.severe(iOException.getMessage());
            }
        }
        return string;
    }

    public static String encodeForURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Unable to encode for URL: " + string + ". " + exception, exception);
            return string;
        }
        return string2;
    }

    public static String removeLastSlashFromURI(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.endsWith("/") && !string2.endsWith("://")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static boolean compareIpAddresses(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return true;
        }
        return false;
    }

    public static List<byte[]> splitArray(byte[] byArray, int n) {
        byte[] byArray2;
        int n2;
        int n3 = byArray.length / n;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n3 + 1);
        if (n >= byArray.length) {
            arrayList.add(byArray);
            return arrayList;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            byArray2 = new byte[n];
            System.arraycopy(byArray, n2 * n, byArray2, 0, byArray2.length);
            arrayList.add(byArray2);
        }
        n2 = byArray.length % n;
        if (n2 > 0) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n3 * n, byArray2, 0, byArray2.length);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    public static byte[] mergeArrayList(List<byte[]> list) {
        Reject.ifNull(list, "list of arrays is null");
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        if (n == 0) {
            return new byte[0];
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    public static <T> List<T[]> splitArray(T[] TArray, int n) {
        int n2 = TArray.length / n;
        int n3 = TArray.length % n;
        int n4 = 0;
        int n5 = 0;
        ArrayList<T[]> arrayList = new ArrayList<T[]>();
        for (int i = 0; i < n2; ++i) {
            arrayList.add(Arrays.copyOfRange(TArray, n4, n5 += n));
            n4 = n5;
        }
        if (n3 > 0) {
            arrayList.add(Arrays.copyOfRange(TArray, n4, n4 + n3));
        }
        return arrayList;
    }

    public static char[] encodeHex(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n << 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cArray[n2++] = DIGITS[(0xF0 & byArray[i]) >>> 4];
            cArray[n2++] = DIGITS[0xF & byArray[i]];
        }
        return cArray;
    }

    public static byte[] md5(byte[] byArray) {
        return Util.getMd5Digest().digest(byArray);
    }

    private static MessageDigest getDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return Util.getDigest("MD5");
    }

    public static boolean betweenVersion(String string, String string2, String string3) {
        boolean bl;
        Reject.ifNull(string, "lowVersion is null");
        Reject.ifNull(string2, "compareVersion is null");
        Reject.ifNull(string3, "highVersion is null");
        boolean bl2 = bl = !Util.compareVersions(string, string2);
        if (!bl) {
            return false;
        }
        return Util.compareVersions(string3, string2);
    }

    public static boolean versionIsMinimumOrHigher(String string, String string2) {
        return !Util.compareVersions(string2, string);
    }

    public static boolean compareVersions(String string, String string2) {
        Reject.ifNull(string, "higherVersion is null");
        Reject.ifNull(string2, "compareVersion is null");
        string = string.trim();
        string2 = string2.trim();
        String string3 = "";
        int n = string.indexOf(32);
        if (n >= 0) {
            string3 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = 0;
        try {
            n2 = Integer.valueOf(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n3 = 0;
        try {
            n3 = Integer.valueOf(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n4 = 0;
        try {
            n4 = Integer.valueOf(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = "";
        int n5 = string2.indexOf(32);
        if (n5 >= 0) {
            string4 = string2.substring(n5 + 1, string2.length());
            string2 = string2.substring(0, n5);
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        int n6 = 0;
        try {
            n6 = Integer.valueOf(stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n7 = 0;
        try {
            n7 = Integer.valueOf(stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n8 = 0;
        try {
            n8 = Integer.valueOf(stringTokenizer2.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 == n6) {
            if (n3 == n7) {
                if (n4 == n8) {
                    return string3.length() < string4.length();
                }
                return n4 > n8;
            }
            return n3 > n7;
        }
        return n2 > n6;
    }

    public static InetSocketAddress parseConnectionString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n = 1337;
        int n2 = string.indexOf(58);
        if (n2 >= 0 && n2 < string.length()) {
            string2 = string.substring(0, n2);
            try {
                n = Integer.parseInt(string.substring(n2 + 1, string.length()));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warning("Illegal port in " + string + ", trying default port");
            }
        }
        return new InetSocketAddress(string2, n);
    }

    public static String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = string2.length();
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n != -1) {
            stringBuilder.append(cArray, n3, n - n3);
            stringBuilder.append(string3);
            n3 = n + n2;
            n = string.indexOf(string2, n3);
        }
        stringBuilder.append(cArray, n3, cArray.length - n3);
        return stringBuilder.toString();
    }

    public static final <K, V> ConcurrentHashMap<K, V> createConcurrentHashMap() {
        return Util.createConcurrentHashMap(16);
    }

    public static final <K, V> ConcurrentHashMap<K, V> createConcurrentHashMap(int n) {
        return new ConcurrentHashMap(n, 0.75f, 4);
    }

    public static final HttpClientBuilder createHttpClientBuilder(Controller controller) {
        TrustManager[] trustManagerArray;
        Reject.ifNull(controller, "Controller");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        if (StringUtils.isNotBlank(System.getProperty("http.proxyHost"))) {
            trustManagerArray = System.getProperty("http.proxyHost");
            int n = Integer.parseInt(System.getProperty("http.proxyPort"));
            HttpHost httpHost = new HttpHost((String)trustManagerArray, n);
            httpClientBuilder.setProxy(httpHost);
            String string = ConfigurationEntry.HTTP_PROXY_USERNAME.getValue(controller);
            if (string == null) {
                string = "";
            }
            if (StringUtils.isNotBlank(string)) {
                String string2 = Util.toString(LoginUtil.deobfuscate(ConfigurationEntry.HTTP_PROXY_PASSWORD.getValue(controller)));
                if (string2 == null) {
                    string2 = "";
                }
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(string, string2);
                AuthScope authScope = new AuthScope((String)trustManagerArray, n);
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(authScope, usernamePasswordCredentials);
                httpClientBuilder.setDefaultCredentialsProvider(basicCredentialsProvider);
            }
        }
        if (ConfigurationEntry.SECURITY_SSL_TRUST_ANY.getValueBoolean(controller).booleanValue()) {
            try {
                trustManagerArray = new TrustManager[]{new NetworkUtil.AllTrustingSSLManager()};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, new SecureRandom());
                httpClientBuilder.setSslcontext(sSLContext);
                httpClientBuilder.setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (Exception exception) {
                LOG.severe("Unable to setup SSL to trust any certificate. " + exception);
            }
        }
        return httpClientBuilder;
    }

    public static final boolean isDuplicateEntryException(Throwable throwable) {
        Object object = throwable.toString().toLowerCase();
        if (throwable.getCause() != null && throwable.getCause().getMessage() != null) {
            object = (String)object + throwable.getCause().getMessage().toLowerCase();
            if (throwable.getCause().getCause() != null && throwable.getCause().getCause().getMessage() != null) {
                object = (String)object + throwable.getCause().getCause().getMessage();
            }
        }
        return Util.isDuplicateEntryException((String)object);
    }

    private static final boolean isDuplicateEntryException(String string) {
        return string.contains("uplicate entry");
    }

    public static final boolean isMySQLDeadlock(LogRecord logRecord) {
        return logRecord.getMessage() != null && Util.isMySQLDeadlock(logRecord.getMessage().toLowerCase()) || logRecord.getThrown() != null && Util.isMySQLDeadlock(logRecord.getThrown());
    }

    public static final boolean isMySQLDeadlock(Throwable throwable) {
        Object object = throwable.toString().toLowerCase();
        if (throwable.getCause() != null && throwable.getCause().getMessage() != null) {
            object = (String)object + throwable.getCause().getMessage().toLowerCase();
            if (throwable.getCause().getCause() != null && throwable.getCause().getCause().getMessage() != null) {
                object = (String)object + throwable.getCause().getCause().getMessage();
            }
        }
        return Util.isMySQLDeadlock((String)object);
    }

    private static final boolean isMySQLDeadlock(String string) {
        return string.contains("wsrep detected") || string.contains("conflict") || string.contains("deadlock") || string.contains("eadlock found");
    }

    public static final boolean isStaleStateException(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof StaleStateException || throwable.toString().contains("StaleStateException")) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static final Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    static {
        try {
            Color color = Color.RED;
            color.brighter();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, Color.RED);
            awtAvailable = true;
        }
        catch (Error error) {
            awtAvailable = false;
        }
        LOG = Logger.getLogger(Util.class.getName());
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

