/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectory;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class UserDirectories {
    private static final Map<String, UserDirectory> userDirectories = new TreeMap<String, UserDirectory>();
    private static final String USER_DIR_DOCUMENTS_DEFAULT = "Documents";
    private static final String USER_DIR_MUSIC_DEFAULT = "Music";
    private static final String USER_DIR_PICTURES_DEFAULT = "Pictures";
    private static final String USER_DIR_VIDEOS_DEFAULT = "Videos";
    private static final String USER_DIR_FAVORITES_DEFAULT = "Favorites";
    private static final String USER_DIR_LINKS = "Links";
    private static final String USER_DIR_RECENT_DOCUMENTS = "Recent Documents";
    private static final String USER_DIR_CONTACTS = "Contacts";
    private static final String USER_DIR_DESKTOP = "Desktop";
    private static final String USER_DIR_DOCUMENTS_REPORTED;
    private static final String USER_DIR_MUSIC_REPORTED;
    private static final String USER_DIR_PICTURES_REPORTED;
    private static final String USER_DIR_VIDEOS_REPORTED;
    private static final String USER_DIR_FAVORITES_REPORTED;
    private static final String APPS_DIR_OUTLOOK;
    private static final String APPS_DIR_WINDOWS_MAIL;
    private static final String USER_DIR_EVOLUTION = ".evolution";
    private static final String USER_DIR_MOVIES = "Movies";
    private static final String USER_DIR_DOWNLOADS = "Downloads";
    private static final String USER_DIR_PUBLIC = "Public";
    private static final String USER_DIR_SITES = "Sites";
    private static final String USER_DIR_DROPBOX = "My Dropbox";
    private static final String APPS_DIR_FIREFOX;
    private static final String APPS_DIR_SUNBIRD;
    private static final String APPS_DIR_THUNDERBIRD = "Thunderbird";
    private static final String APPS_DIR_FIREFOX2 = "firefox";
    private static final String APPS_DIR_SUNBIRD2 = "sunbird";
    private static final String APPS_DIR_THUNDERBIRD2 = "thunderbird";

    public static String getDocumentsReported() {
        return USER_DIR_DOCUMENTS_REPORTED;
    }

    public static String getMusicReported() {
        return USER_DIR_MUSIC_REPORTED;
    }

    public static String getVideosReported() {
        return USER_DIR_VIDEOS_REPORTED;
    }

    public static String getPicturesReported() {
        return USER_DIR_PICTURES_REPORTED;
    }

    public static UserDirectory getDesktopDirectory() {
        return UserDirectories.getUserDirectories().get(Translation.get("user.dir.desktop"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, UserDirectory> getUserDirectories() {
        if (userDirectories.isEmpty()) {
            Map<String, UserDirectory> map = userDirectories;
            synchronized (map) {
                UserDirectories.findUserDirectories();
            }
        }
        return userDirectories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, UserDirectory> getUserDirectories(Controller controller) {
        if (!ConfigurationEntry.FOLDER_MAP_USER_DIRECTORIES.getValueBoolean(controller).booleanValue()) {
            return Collections.emptyMap();
        }
        if (userDirectories.isEmpty()) {
            Map<String, UserDirectory> map = userDirectories;
            synchronized (map) {
                UserDirectories.findUserDirectories();
            }
        }
        return userDirectories;
    }

    public static Map<String, UserDirectory> getUserDirectoriesFiltered(Controller controller, boolean bl) {
        if (!ConfigurationEntry.FOLDER_MAP_USER_DIRECTORIES.getValueBoolean(controller).booleanValue()) {
            return Collections.emptyMap();
        }
        TreeMap<String, UserDirectory> treeMap = new TreeMap<String, UserDirectory>(UserDirectories.getUserDirectories());
        Iterator iterator = treeMap.values().iterator();
        block0: while (iterator.hasNext()) {
            UserDirectory userDirectory = (UserDirectory)iterator.next();
            if (!bl && "APP DATA".equalsIgnoreCase(userDirectory.getTranslatedName())) {
                iterator.remove();
                continue;
            }
            Path path = userDirectory.getDirectory();
            for (Folder folder : controller.getFolderRepository().getFolders()) {
                if (!folder.getLocalBase().equals(path)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return treeMap;
    }

    private static void findUserDirectories() {
        boolean bl;
        Path path = Paths.get(System.getProperty("user.home"), new String[0]);
        UserDirectories.addTargetDirectory(path, USER_DIR_CONTACTS, "user.dir.contacts", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_DESKTOP, "user.dir.desktop", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_EVOLUTION, "user.dir.evolution", true);
        UserDirectories.addTargetDirectory(path, USER_DIR_LINKS, "user.dir.links", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_MOVIES, "user.dir.movies", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_DOWNLOADS, "user.dir.downloads", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_PUBLIC, "user.dir.public", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_SITES, "user.dir.sites", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_DROPBOX, "user.dir.dropbox", false);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (OSUtil.isWindowsSystem()) {
            if (USER_DIR_DOCUMENTS_REPORTED != null) {
                bl2 = UserDirectories.addTargetDirectory(Paths.get(USER_DIR_DOCUMENTS_REPORTED, new String[0]), "user.dir.documents", false, "user.dir.documents");
            }
            if (USER_DIR_MUSIC_REPORTED != null) {
                bl3 = UserDirectories.addTargetDirectory(Paths.get(USER_DIR_MUSIC_REPORTED, new String[0]), "user.dir.music", false, "user.dir.music");
            }
            if (USER_DIR_PICTURES_REPORTED != null) {
                bl4 = UserDirectories.addTargetDirectory(Paths.get(USER_DIR_PICTURES_REPORTED, new String[0]), "user.dir.pictures", false, "user.dir.pictures");
            }
            if (USER_DIR_VIDEOS_REPORTED != null) {
                bl5 = UserDirectories.addTargetDirectory(Paths.get(USER_DIR_VIDEOS_REPORTED, new String[0]), "user.dir.videos", false, "user.dir.videos");
            }
            if (USER_DIR_FAVORITES_REPORTED != null) {
                bl5 = UserDirectories.addTargetDirectory(Paths.get(USER_DIR_FAVORITES_REPORTED, new String[0]), "user.dir.favorites", false);
            }
        }
        if (!bl2) {
            UserDirectories.addTargetDirectory(path, USER_DIR_DOCUMENTS_DEFAULT, "user.dir.documents", false);
        }
        if (!bl3) {
            UserDirectories.addTargetDirectory(path, USER_DIR_MUSIC_DEFAULT, "user.dir.music", false);
        }
        if (!bl4) {
            UserDirectories.addTargetDirectory(path, USER_DIR_PICTURES_DEFAULT, "user.dir.pictures", false);
        }
        if (!bl5) {
            UserDirectories.addTargetDirectory(path, USER_DIR_VIDEOS_DEFAULT, "user.dir.videos", false);
        }
        if (!(bl = false)) {
            UserDirectories.addTargetDirectory(path, USER_DIR_FAVORITES_DEFAULT, "user.dir.favorites", false);
        }
        UserDirectories.addTargetDirectory(path, USER_DIR_RECENT_DOCUMENTS, "user.dir.recent_documents", false);
        UserDirectories.addTargetDirectory(path, USER_DIR_VIDEOS_DEFAULT, "user.dir.videos", false);
        if (OSUtil.isWindowsSystem()) {
            String string = WinUtils.getAppDataCurrentUser();
            if (string != null) {
                Path path2 = Paths.get(string, new String[0]);
                UserDirectories.addTargetDirectory(path2, "apps.dir", true);
                UserDirectories.addTargetDirectory(path2, APPS_DIR_FIREFOX, "apps.dir.firefox", false);
                UserDirectories.addTargetDirectory(path2, APPS_DIR_SUNBIRD, "apps.dir.sunbird", false);
                if (Feature.USER_DIRECTORIES_EMAIL_CLIENTS.isEnabled()) {
                    UserDirectories.addTargetDirectory(path2, APPS_DIR_THUNDERBIRD, "apps.dir.thunderbird", false);
                }
                if (APPS_DIR_OUTLOOK != null) {
                    UserDirectories.addTargetDirectory(Paths.get(APPS_DIR_OUTLOOK, new String[0]), "apps.dir.outlook", false);
                }
                if (APPS_DIR_WINDOWS_MAIL != null) {
                    UserDirectories.addTargetDirectory(Paths.get(APPS_DIR_WINDOWS_MAIL, new String[0]), "apps.dir.windows_mail", false);
                }
            } else {
                Logger.getAnonymousLogger().severe("Application data directory not found.");
            }
        } else if (OSUtil.isLinux()) {
            Path path3 = Paths.get("/etc", new String[0]);
            UserDirectories.addTargetDirectory(path3, APPS_DIR_FIREFOX2, "apps.dir.firefox", false);
            UserDirectories.addTargetDirectory(path3, APPS_DIR_SUNBIRD2, "apps.dir.sunbird", false);
            if (Feature.USER_DIRECTORIES_EMAIL_CLIENTS.isEnabled()) {
                UserDirectories.addTargetDirectory(path3, APPS_DIR_THUNDERBIRD2, "apps.dir.thunderbird", false);
            }
        } else if (OSUtil.isMacOS()) {
            Path path4 = path.resolve("Library");
            UserDirectories.addTargetDirectory(path4, APPS_DIR_FIREFOX, "apps.dir.firefox", false);
            UserDirectories.addTargetDirectory(path4, APPS_DIR_SUNBIRD, "apps.dir.sunbird", false);
            if (Feature.USER_DIRECTORIES_EMAIL_CLIENTS.isEnabled()) {
                UserDirectories.addTargetDirectory(path4, APPS_DIR_THUNDERBIRD, "apps.dir.thunderbird", false);
            }
        }
    }

    private static void addTargetDirectory(Path path, String string, String string2, boolean bl) {
        Path path2 = UserDirectories.joinFile(path, string);
        UserDirectories.addTargetDirectory(path2, string2, bl);
    }

    private static Path joinFile(Path path, String string) {
        return path.resolve(string);
    }

    private static boolean addTargetDirectory(Path path, String string, boolean bl) {
        return UserDirectories.addTargetDirectory(path, string, bl, string);
    }

    private static boolean addTargetDirectory(Path path, String string, boolean bl, String string2) {
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && (bl || !Files.isHidden(path))) {
                String string3 = Translation.get(string);
                UserDirectory userDirectory = new UserDirectory(string3, "$" + string2, path);
                userDirectories.put(string3, userDirectory);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static {
        APPS_DIR_FIREFOX = "Mozilla" + FileSystems.getDefault().getSeparator() + "Firefox";
        APPS_DIR_SUNBIRD = "Mozilla" + FileSystems.getDefault().getSeparator() + "Sunbird";
        if (WinUtils.getInstance() != null) {
            APPS_DIR_OUTLOOK = Feature.USER_DIRECTORIES_EMAIL_CLIENTS.isEnabled() ? WinUtils.getInstance().getSystemFolderPath(28, false) + FileSystems.getDefault().getSeparator() + "Microsoft" + FileSystems.getDefault().getSeparator() + "Outlook" : null;
            USER_DIR_DOCUMENTS_REPORTED = WinUtils.getInstance().getSystemFolderPath(5, false);
            USER_DIR_MUSIC_REPORTED = WinUtils.getInstance().getSystemFolderPath(13, false);
            USER_DIR_PICTURES_REPORTED = WinUtils.getInstance().getSystemFolderPath(39, false);
            USER_DIR_VIDEOS_REPORTED = WinUtils.getInstance().getSystemFolderPath(14, false);
            USER_DIR_FAVORITES_REPORTED = WinUtils.getInstance().getSystemFolderPath(6, false);
            APPS_DIR_WINDOWS_MAIL = Feature.USER_DIRECTORIES_EMAIL_CLIENTS.isEnabled() ? WinUtils.getInstance().getSystemFolderPath(28, false) + FileSystems.getDefault().getSeparator() + "Microsoft" + FileSystems.getDefault().getSeparator() + "Windows Mail" : null;
        } else {
            USER_DIR_DOCUMENTS_REPORTED = null;
            USER_DIR_MUSIC_REPORTED = null;
            USER_DIR_PICTURES_REPORTED = null;
            USER_DIR_VIDEOS_REPORTED = null;
            USER_DIR_FAVORITES_REPORTED = null;
            APPS_DIR_OUTLOOK = null;
            APPS_DIR_WINDOWS_MAIL = null;
        }
    }
}

