/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Reject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class StringUtils {
    public static final String AEL_SPECIAL_ENCODING_UNICODE = new String(new byte[]{97, -52, -120}, Convert.UTF8);
    public static final String AEU_SPECIAL_ENCODING_UNICODE = AEL_SPECIAL_ENCODING_UNICODE.toUpperCase(Locale.ROOT);
    public static final String OEL_SPECIAL_ENCODING_UNICODE = new String(new byte[]{111, -52, -120}, Convert.UTF8);
    public static final String OEU_SPECIAL_ENCODING_UNICODE = OEL_SPECIAL_ENCODING_UNICODE.toUpperCase(Locale.ROOT);
    public static final String UEL_SPECIAL_ENCODING_UNICODE = new String(new byte[]{117, -52, -120}, Convert.UTF8);
    public static final String UEU_SPECIAL_ENCODING_UNICODE = UEL_SPECIAL_ENCODING_UNICODE.toUpperCase(Locale.ROOT);

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankAny(String ... stringArray) {
        for (String string : stringArray) {
            if (!StringUtils.isBlank(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String replaceIfNecessary(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (!string.contains(string2)) {
            return string;
        }
        return string.replace(string2, string3);
    }

    public static boolean isEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    public static String join(String string, Iterable<String> iterable) {
        Iterator<String> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        return StringUtils.join(string, Arrays.asList(stringArray));
    }

    public static int countChar(String string, char c) {
        Reject.ifBlank(string, "String is blank");
        int n = 0;
        int n2 = 0;
        n2 = string.indexOf(c, n2);
        while (n2 != -1) {
            n2 = string.indexOf(c, n2 + 1);
            ++n;
        }
        return n;
    }

    public static boolean startsWithString(String string, String string2) {
        Reject.ifNull(string, "inputString is blank");
        Reject.ifNull(string2, "subString is blank");
        return string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public static boolean hasSubString(String string, String string2) {
        Reject.ifNull(string, "inputString is blank");
        Reject.ifNull(string2, "subString is blank");
        return string.toLowerCase().contains(string2.toLowerCase());
    }

    public static String cutNotes(String string) {
        if (string.length() <= 2048) {
            return string;
        }
        String string2 = string.substring(string.length() - 2049);
        int n = string2.indexOf("\n");
        if (n <= -1 || n >= 2048) {
            n = 0;
        }
        return string2.substring(n + 1, 2049);
    }

    public static boolean containsDecomposedForm(String string) {
        return string.contains(AEL_SPECIAL_ENCODING_UNICODE) || string.contains(AEU_SPECIAL_ENCODING_UNICODE) || string.contains(OEL_SPECIAL_ENCODING_UNICODE) || string.contains(OEU_SPECIAL_ENCODING_UNICODE) || string.contains(UEL_SPECIAL_ENCODING_UNICODE) || string.contains(UEU_SPECIAL_ENCODING_UNICODE);
    }

    public static String convertToPrecomposedForm(String string) {
        String string2 = string;
        string2 = string2.replaceAll(AEL_SPECIAL_ENCODING_UNICODE, "\u00e4");
        string2 = string2.replaceAll(AEU_SPECIAL_ENCODING_UNICODE, "\u00c4");
        string2 = string2.replaceAll(OEL_SPECIAL_ENCODING_UNICODE, "\u00f6");
        string2 = string2.replaceAll(OEU_SPECIAL_ENCODING_UNICODE, "\u00d6");
        string2 = string2.replaceAll(UEL_SPECIAL_ENCODING_UNICODE, "\u00fc");
        string2 = string2.replaceAll(UEU_SPECIAL_ENCODING_UNICODE, "\u00dc");
        return string2;
    }

    public static List cutOnLineBreaks(String string) {
        List<String> list = Arrays.asList(string.replaceAll("\\r", "").split("\\n"));
        return list;
    }
}

