/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = Logger.getLogger(NamedThreadFactory.class.getName());
    private final Thread.UncaughtExceptionHandler exceptionHandler = new ExceptionHandler();
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public NamedThreadFactory(String string) {
        this.namePrefix = string;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
        thread.setUncaughtExceptionHandler(this.exceptionHandler);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    private final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
            log.log(Level.SEVERE, "Exception in " + thread + ": " + throwable.toString(), throwable);
        }
    }
}

