/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.AntiSerializationVulnerability;
import de.dal33t.powerfolder.util.StackDump;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LookAheadObjectInputStream
extends ObjectInputStream {
    private static final Logger LOG = Logger.getLogger(LookAheadObjectInputStream.class.getName());

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (AntiSerializationVulnerability.isBlacklisted(objectStreamClass.getName())) {
            LOG.log(Level.WARNING, "Unauthorized deserialization attempt: " + objectStreamClass.getName());
            throw new InvalidClassException("Unauthorized deserialization attempt", objectStreamClass.getName());
        }
        if (!AntiSerializationVulnerability.isWhitelisted(objectStreamClass.getName())) {
            LOG.log(Level.WARNING, "Unauthorized deserialization attempt: " + objectStreamClass.getName());
            LOG.log(Level.FINE, "Unauthorized deserialization attempt: " + objectStreamClass.getName(), new StackDump());
            throw new InvalidClassException("Unauthorized deserialization attempt", objectStreamClass.getName());
        }
        return super.resolveClass(objectStreamClass);
    }

    public LookAheadObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }
}

