/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

public class JavaVersion
implements Comparable<JavaVersion> {
    private static JavaVersion systemVersion;
    private final int major;
    private final int minor;
    private final int revision;
    private final int update;
    private final int build;

    public JavaVersion(int n, int n2, int n3, int n4, int n5) {
        this.major = n;
        this.minor = n2;
        this.revision = n3;
        this.update = n4;
        this.build = n5;
    }

    public JavaVersion(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0);
    }

    public JavaVersion(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0);
    }

    public JavaVersion(int n, int n2) {
        this(n, n2, 0, 0, 0);
    }

    public int getBuild() {
        return this.build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getUpdate() {
        return this.update;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavaVersion javaVersion = (JavaVersion)object;
        if (this.build != javaVersion.build) {
            return false;
        }
        if (this.major != javaVersion.major) {
            return false;
        }
        if (this.minor != javaVersion.minor) {
            return false;
        }
        if (this.revision != javaVersion.revision) {
            return false;
        }
        return this.update == javaVersion.update;
    }

    public int hashCode() {
        int n = this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.revision;
        n = 31 * n + this.build;
        n = 31 * n + this.update;
        return n;
    }

    @Override
    public int compareTo(JavaVersion javaVersion) {
        if (this.major == javaVersion.major) {
            if (this.minor == javaVersion.minor) {
                if (this.revision == javaVersion.revision) {
                    if (this.update == javaVersion.update) {
                        if (this.build == javaVersion.build) {
                            return 0;
                        }
                        return this.build - javaVersion.build;
                    }
                    return 100 * this.update - 100 * javaVersion.update;
                }
                return 10000 * this.revision - 10000 * javaVersion.revision;
            }
            return 1000000 * this.minor - 1000000 * javaVersion.minor;
        }
        return 100000000 * this.major - 100000000 * javaVersion.major;
    }

    public String toString() {
        if (this.update > 0) {
            if (this.build > 0) {
                if (this.build <= 10) {
                    return this.major + "." + this.minor + "." + this.revision + "_" + this.update + "-b0" + this.build;
                }
                return this.major + "." + this.minor + "." + this.revision + "_" + this.update + "-b" + this.build;
            }
            return this.major + "." + this.minor + "." + this.revision + "_" + this.update;
        }
        return this.major + "." + this.minor + "." + this.revision;
    }

    public boolean isOpenJDK() {
        String string = System.getProperty("java.vm.name");
        return string.contains("OpenJDK");
    }

    public static JavaVersion systemVersion() {
        if (systemVersion == null) {
            String string = System.getProperty("java.runtime.version");
            if (string == null) {
                string = System.getProperty("java.version");
            }
            if (string == null) {
                string = System.getProperty("java.specification.version");
            }
            if (string == null) {
                systemVersion = new JavaVersion(0, 0);
                return systemVersion;
            }
            try {
                systemVersion = JavaVersion.parse(string);
            }
            catch (Exception exception) {
                systemVersion = new JavaVersion(0, 0);
            }
        }
        return systemVersion;
    }

    public static JavaVersion parse(String string) {
        String[] stringArray;
        if (string != null) {
            stringArray = string.split("(\\.|_)");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "0";
            stringArray = stringArray2;
            stringArray2[1] = "0";
        }
        String[] stringArray3 = stringArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Segment segment = new Segment(string, stringArray3[0]);
        n = segment.number;
        if (stringArray3.length > 1) {
            segment = new Segment(string, stringArray3[1]);
            n2 = segment.number;
            if (segment.containsAdditionalNumber()) {
                n4 = segment.additionalNumber;
            }
        } else if (segment.containsAdditionalNumber()) {
            n3 = segment.additionalNumber;
        }
        if (stringArray3.length > 2) {
            segment = new Segment(string, stringArray3[2]);
            n3 = segment.number;
            if (segment.containsAdditionalNumber()) {
                n4 = segment.additionalNumber;
            }
        }
        if (stringArray3.length > 3) {
            segment = new Segment(string, stringArray3[3]);
            n4 = segment.number;
            if (segment.containsAdditionalNumber()) {
                n5 = segment.additionalNumber;
            }
        }
        return new JavaVersion(n, n2, n3, n4, n5);
    }

    private static class Segment {
        private int number;
        private int additionalNumber = -1;

        private boolean containsAdditionalNumber() {
            return this.additionalNumber >= 0;
        }

        private Segment(String string, String string2) {
            try {
                try {
                    this.number = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    String[] stringArray = new String[]{"0", "0"};
                    if (string2.contains("+")) {
                        stringArray = string2.split("\\+");
                    } else if (string2.contains("_")) {
                        stringArray = string2.split("_");
                    } else if (string2.contains("-b")) {
                        stringArray = string2.split("-b");
                    }
                    this.number = Integer.parseInt(stringArray[0]);
                    String string3 = stringArray[1].replaceAll("-", "").replaceAll("\\+", "").replaceAll("b", "").replaceAll("_", "_");
                    this.additionalNumber = Integer.parseInt(string3);
                }
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Failed to parse java version part: " + string2 + " of Java Version " + string + ". " + runtimeException);
            }
        }
    }
}

