/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.LookAheadObjectInputStream;
import de.dal33t.powerfolder.util.PFZIPOutputStream;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ByteSerializer
extends Loggable {
    private static final Logger LOG = Logger.getLogger(ByteSerializer.class.getName());
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private static final int MAX_CACHE_BUFFER_SIZE = 0;
    private static final boolean CACHE_OUT_BUFFER = false;
    private Reference<ByteArrayOutputStream> outBufferRef;
    private Reference<byte[]> inBufferRef;
    public static boolean BENCHMARK = false;
    private static final Map<Class<?>, Integer> CLASS_STATS = new ConcurrentHashMap();
    private static long totalTime = 0L;
    private static int totalObjects = 0;

    public byte[] serialize(Serializable serializable, boolean bl, int n) throws IOException {
        int n2;
        int n3;
        OutputStream outputStream;
        OutputStream outputStream2;
        ByteArrayOutputStream byteArrayOutputStream;
        long l = System.currentTimeMillis();
        if (this.outBufferRef != null && this.outBufferRef.get() != null) {
            byteArrayOutputStream = this.outBufferRef.get();
            byteArrayOutputStream.reset();
        } else {
            byteArrayOutputStream = new ByteArrayOutputStream(512);
        }
        if (bl) {
            outputStream2 = new PFZIPOutputStream(byteArrayOutputStream);
            outputStream = outputStream2;
        } else {
            outputStream = byteArrayOutputStream;
        }
        outputStream2 = new ObjectOutputStream(outputStream);
        try {
            ((ObjectOutputStream)outputStream2).writeUnshared(serializable);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            LOG.log(Level.WARNING, "Problem while serializing: " + streamCorruptedException, streamCorruptedException);
            throw streamCorruptedException;
        }
        catch (InvalidClassException invalidClassException) {
            LOG.log(Level.WARNING, "Problem while serializing: " + serializable + ": " + invalidClassException, invalidClassException);
            throw invalidClassException;
        }
        ((ObjectOutputStream)outputStream2).close();
        if (n > 0 && (n3 = byteArrayOutputStream.size() % n) != 0) {
            n2 = n - n3;
            for (int i = 0; i < n2; ++i) {
                byteArrayOutputStream.write(0);
            }
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        if (byteArrayOutputStream.size() >= 262144 && !serializable.getClass().getName().contains("ClusterCacheUpdate") && this.isFine()) {
            String string = serializable.toString();
            if (string.length() > 500) {
                string = string.substring(0, 500);
            }
            this.logFine("Send buffer exceeds 256KB! " + Format.formatBytes(byteArrayOutputStream.size()) + ". Message: " + string);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (BENCHMARK) {
            ++totalObjects;
            totalTime += System.currentTimeMillis() - l;
            n2 = 0;
            if (CLASS_STATS.containsKey(serializable.getClass())) {
                n2 = CLASS_STATS.get(serializable.getClass());
            }
            CLASS_STATS.put(serializable.getClass(), ++n2);
        }
        return byArray;
    }

    public byte[] read(InputStream inputStream, int n) throws IOException {
        if (n > 0xA00000) {
            throw new IOException("Max buffersize overflow while reading. expected size " + n);
        }
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[n];
            StreamUtils.read(inputStream, byArray, 0, n);
            return byArray;
        }
        if (this.inBufferRef != null && this.inBufferRef.get() != null) {
            byArray = this.inBufferRef.get();
        }
        if (byArray == null || byArray.length < n) {
            if (this.isFiner()) {
                String string = byArray == null ? "Creating" : "Extending";
                this.logFiner(string + " receive buffer (" + Format.formatBytes(n) + ")");
            }
            if (n >= 131072) {
                this.logWarning("Recived buffer exceeds 128KB! " + Format.formatBytes(n));
            }
            byArray = new byte[n];
            this.inBufferRef = new SoftReference<byte[]>(byArray);
        }
        StreamUtils.read(inputStream, byArray, 0, n);
        return byArray;
    }

    public static byte[] serializeStatic(Serializable serializable, boolean bl) throws IOException {
        return new ByteSerializer().serialize(serializable, bl, -1);
    }

    public static Object deserializeStatic(byte[] byArray, boolean bl) throws IOException, ClassNotFoundException {
        Object object;
        block6: {
            try {
                object = ByteSerializer.deserialize0(byArray, bl);
            }
            catch (IOException iOException) {
                try {
                    object = ByteSerializer.deserialize0(byArray, !bl);
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    LOG.log(Level.FINE, "While deserializing " + (bl ? "compressed" : "uncompressed") + ": " + iOException);
                    if (!streamCorruptedException.toString().toLowerCase().contains("invalid stream header: 1f8b0800")) {
                        LOG.log(Level.FINE, "While deserializing " + (!bl ? "compressed" : "uncompressed") + ": " + streamCorruptedException);
                    }
                    throw streamCorruptedException;
                }
                catch (InvalidClassException invalidClassException) {
                    LOG.log(Level.WARNING, "While deserializing: " + invalidClassException, invalidClassException);
                    throw invalidClassException;
                }
                if (object instanceof Identity) break block6;
                LOG.warning("Stream was not as expected (" + (bl ? "compression was expected, but received uncompressed data" : "no compression was expected, but received compressed data") + ") on " + object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserialize0(byte[] byArray, boolean bl) throws IOException, ClassNotFoundException {
        long l = System.currentTimeMillis();
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            InputStream inputStream;
            Object object2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (bl) {
                object2 = new GZIPInputStream(byteArrayInputStream);
                inputStream = object2;
            } else {
                inputStream = byteArrayInputStream;
            }
            objectInputStream = new LookAheadObjectInputStream(inputStream);
            object2 = object = objectInputStream.readUnshared();
            return object2;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (BENCHMARK && object != null) {
                ++totalObjects;
                totalTime += System.currentTimeMillis() - l;
                int n = 0;
                if (CLASS_STATS.containsKey(object.getClass())) {
                    n = CLASS_STATS.get(object.getClass());
                }
                CLASS_STATS.put(object.getClass(), ++n);
            }
        }
    }

    public static final void printStats() {
        if (totalObjects != 0) {
            LOG.fine("Serialization perfomance: " + totalObjects + " took " + totalTime + "ms. That is " + totalTime * 1000L / (long)totalObjects + " ms/1k objects. Message stats: ");
            ArrayList arrayList = new ArrayList(CLASS_STATS.keySet());
            Collections.sort(arrayList, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> clazz, Class<?> clazz2) {
                    Integer n = (Integer)CLASS_STATS.get(clazz);
                    Integer n2 = (Integer)CLASS_STATS.get(clazz2);
                    if (n2 == null) {
                        return -1;
                    }
                    return n2.compareTo(n);
                }
            });
            for (Class clazz : arrayList) {
                LOG.fine(" " + clazz.getName() + ": " + CLASS_STATS.get(clazz));
            }
        } else {
            LOG.fine("Serialization perfomance: " + totalObjects);
        }
    }
}

