/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.security.SecurityException;
import de.dal33t.powerfolder.security.Token;
import de.dal33t.powerfolder.ui.dialog.ConfigurationLoaderDialog;
import de.dal33t.powerfolder.ui.util.IdPSelectionBox;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.widget.LinkLabel;
import de.dal33t.powerfolder.ui.wizard.DesktopSyncSetupPanel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import jwf.WizardPanel;

public class LoginPanel
extends PFWizardPanel {
    private static final Logger LOG = Logger.getLogger(LoginPanel.class.getName());
    private static final String TOKEN_PLACEHOLDER = "_TOKEN_PLACEHOLDER_";
    private ServerClient client;
    private boolean showUseOS;
    private JComboBox<String> serverURLBox;
    private JLabel serverURLLabel;
    private JLabel idPLabel;
    private IdPSelectionBox idPSelectBox;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private LinkLabel recoverPasswordLabel;
    private LinkLabel createAccountLabel;
    private JLabel connectingLabel;
    private JLabel serverLabel;
    private ActionLabel serverInfoLabel;
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private JProgressBar workingBar;
    private JCheckBox rememberPasswordBox;
    private JCheckBox useOSBox;
    private WizardPanel nextPanel;

    public LoginPanel(Controller controller, WizardPanel wizardPanel, boolean bl) {
        this(controller, controller.getOSClient(), wizardPanel, bl);
    }

    public LoginPanel(Controller controller, ServerClient serverClient, WizardPanel wizardPanel, boolean bl) {
        super(controller);
        Reject.ifNull(wizardPanel, "Nextpanel is null");
        this.nextPanel = wizardPanel;
        this.client = serverClient;
        this.showUseOS = bl;
        LOG.log(Level.FINE, "Opening login wizard");
    }

    @Override
    public boolean hasNext() {
        return !(!this.client.isConnected() || StringUtils.isEmpty(this.usernameField.getText()) || this.passwordField.getPassword() == null || this.passwordField.getPassword().length <= 0 || StringUtils.isNotBlank(ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.getValue(this.getController())) && !this.idPSelectBox.isListLoaded() || this.idPSelectBox != null && this.idPSelectBox.getSelectedIndex() == 0);
    }

    @Override
    public WizardPanel next() {
        this.nextPanel = DesktopSyncSetupPanel.insertStepIfAvailable(this.getController(), this.nextPanel, this.client);
        return new SwingWorkerPanel(this.getController(), new LoginTask(), Translation.get("wizard.login_online_storage.logging_in"), Translation.get("wizard.login_online_storage.logging_in.text"), this.nextPanel);
    }

    @Override
    protected JPanel buildContent() {
        String string = StringUtils.isBlank(ConfigurationEntry.SERVER_CONNECTION_URLS.getValue(this.getController())) || StringUtils.isBlank(ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.getValue(this.getController())) ? "15dlu, 7dlu, 15dlu, 7dlu, 15dlu, 3dlu, 15dlu, 3dlu, 15dlu, 34dlu, pref, 20dlu, pref, 3dlu, pref, 3dlu, pref" : "15dlu, 7dlu, 15dlu, 7dlu, 15dlu, 7dlu, 15dlu, 3dlu, 15dlu, 3dlu, 15dlu, 34dlu, pref, 3dlu, pref, 20dlu, pref, 3dlu, pref";
        FormLayout formLayout = new FormLayout("50dlu, 3dlu, 110dlu, 40dlu, pref", string);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        if (StringUtils.isNotBlank(ConfigurationEntry.SERVER_CONNECTION_URLS.getValue(this.getController()))) {
            panelBuilder.add((Component)this.serverURLLabel, cellConstraints.xy(1, n));
            panelBuilder.add(this.serverURLBox, cellConstraints.xy(3, n));
            n += 2;
        }
        if (StringUtils.isNotBlank(ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.getValue(this.getController()))) {
            panelBuilder.add((Component)this.idPLabel, cellConstraints.xy(1, n));
            panelBuilder.add((Component)this.idPSelectBox, cellConstraints.xy(3, n));
            n += 2;
        }
        panelBuilder.add((Component)this.usernameLabel, cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.usernameField, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.connectingLabel, cellConstraints.xyw(1, n, 4));
        panelBuilder.add((Component)this.passwordLabel, cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.passwordField, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.workingBar, cellConstraints.xyw(1, n, 3));
        panelBuilder.add((Component)this.rememberPasswordBox, cellConstraints.xyw(3, n += 2, 2));
        panelBuilder.add((Component)this.recoverPasswordLabel.getUIComponent(), cellConstraints.xyw(3, n += 2, 2));
        panelBuilder.add((Component)this.createAccountLabel.getUIComponent(), cellConstraints.xyw(3, n += 2, 2));
        panelBuilder.add((Component)this.serverLabel, cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.serverInfoLabel.getUIComponent(), cellConstraints.xyw(3, n, 2));
        n += 2;
        if (this.showUseOS) {
            panelBuilder.add((Component)this.useOSBox, cellConstraints.xyw(1, n, 4));
            LinkLabel linkLabel = new LinkLabel(this.getController(), Translation.get("wizard.webservice.learn_more"), ConfigurationEntry.PROVIDER_ABOUT_URL.getValue(this.getController()));
            panelBuilder.add((Component)linkLabel.getUIComponent(), cellConstraints.xyw(1, n += 2, 5));
            n += 2;
        }
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        boolean bl = ConfigurationEntry.SERVER_CONNECT_CHANGE_LOGIN_ALLOWED.getValueBoolean(this.getController());
        boolean bl2 = ConfigurationEntry.SERVER_CONNECT_REMEMBER_PASSWORD_ALLOWED.getValueBoolean(this.getController());
        this.serverLabel = new JLabel(Translation.get("general.server"));
        this.serverInfoLabel = new ActionLabel(this.getController(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ConfigurationLoaderDialog(LoginPanel.this.getController()).openAndWait();
            }
        });
        this.serverInfoLabel.setText(this.client.getServerString());
        this.serverInfoLabel.setEnabled(bl);
        if (StringUtils.isNotBlank(ConfigurationEntry.SERVER_CONNECTION_URLS.getValue(this.getController()))) {
            this.serverURLLabel = new JLabel(Translation.get("general.server"));
            String string = this.client.getWebURL();
            int n = 0;
            String string2 = ConfigurationEntry.SERVER_CONNECTION_URLS.getValue(this.getController());
            String[] stringArray = string2.split(";");
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    String string3 = stringArray[i];
                    stringArray2[i] = string3.substring(0, string3.indexOf("="));
                    String string4 = string3.substring(string3.indexOf("=") + 1);
                    if (!string4.equals(string)) continue;
                    n = i;
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger(LoginPanel.class.getName()).warning("Unable to read servers config: " + string2);
                }
            }
            this.serverURLBox = new JComboBox<String>(stringArray2);
            this.serverURLBox.setSelectedIndex(n);
            this.serverURLBox.setEditable(false);
            this.serverURLBox.addActionListener(new ServerSelectAction());
        }
        if (StringUtils.isNotBlank(ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.getValue(this.getController()))) {
            this.idPLabel = new JLabel(Translation.get("general.idp"));
            this.idPSelectBox = new IdPSelectionBox(this.getController());
            this.idPSelectBox.addItemListener(itemEvent -> this.updateButtons());
            this.idPSelectBox.addItemListener(itemEvent -> this.updateOnlineStatus());
        }
        this.usernameLabel = new JLabel(LoginUtil.getUsernameLabel(this.getController()));
        this.usernameField = new JTextField();
        this.usernameField.addKeyListener(new MyKeyListener());
        this.usernameField.setEditable(bl);
        this.passwordLabel = new JLabel(Translation.get("general.password") + ":");
        this.passwordField = new JPasswordField();
        this.passwordField.setEditable(bl);
        this.passwordField.addKeyListener(new MyKeyListener());
        if (StringUtils.isNotBlank(ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.getValue(this.getController()))) {
            this.usernameField.setText(ConfigurationEntry.SERVER_CONNECT_USERNAME.getValue(this.getController()));
            if (ConfigurationEntry.SERVER_CONNECT_PASSWORD.hasNonBlankValue(this.getController())) {
                this.passwordField.setText(new String(LoginUtil.deobfuscate(ConfigurationEntry.SERVER_CONNECT_PASSWORD.getValue(this.getController()))));
            } else if (ConfigurationEntry.SERVER_CONNECT_TOKEN.hasNonBlankValue(this.getController())) {
                if (!Token.isExpired(this.client.getDeviceToken())) {
                    this.passwordField.setText(TOKEN_PLACEHOLDER);
                } else {
                    this.passwordField.setText("");
                }
            }
        } else if (this.client.isConnected()) {
            this.usernameField.setText(this.client.getUsername());
            if (!this.client.isPasswordEmpty()) {
                this.passwordField.setText(this.client.getPasswordClearText());
            } else if (this.client.isTokenLogin()) {
                if (!Token.isExpired(this.client.getDeviceToken())) {
                    this.passwordField.setText(TOKEN_PLACEHOLDER);
                } else {
                    this.passwordField.setText("");
                }
            }
        }
        this.rememberPasswordBox = BasicComponentFactory.createCheckBox(PreferencesEntry.SERVER_REMEMBER_PASSWORD.getModel(this.getController()), Translation.get("wizard.login_online_storage.remember_password"));
        this.rememberPasswordBox.setOpaque(false);
        this.rememberPasswordBox.setVisible(bl && bl2);
        this.recoverPasswordLabel = new LinkLabel(this.getController(), Translation.get("exp.wizard.webservice.recover_password"), this.client.getRecoverPasswordURL());
        this.recoverPasswordLabel.setVisible(this.client.supportsRecoverPassword());
        this.createAccountLabel = new LinkLabel(this.getController(), Translation.get("wizard.activation.signup_account"), this.client.getRegisterURL());
        this.createAccountLabel.setVisible(this.client.supportsWebRegistration());
        this.useOSBox = new JCheckBox(Translation.get("wizard.login_online_storage.no_os"));
        this.useOSBox.setSelected(PreferencesEntry.USE_ONLINE_STORAGE.getValueBoolean(this.getController()) == false);
        this.useOSBox.addActionListener(actionEvent -> PreferencesEntry.USE_ONLINE_STORAGE.setValue(this.getController(), !this.useOSBox.isSelected()));
        this.useOSBox.setOpaque(false);
        this.connectingLabel = SimpleComponentFactory.createLabel(Translation.get("wizard.login_online_storage.connecting"));
        this.workingBar = new JProgressBar();
        this.workingBar.setIndeterminate(true);
        this.updateOnlineStatus();
        this.client.addListener(new MyServerClientListner());
        this.getController().scheduleAndRepeat(() -> {
            if (!this.client.isConnected()) {
                this.getWizard().next();
            }
        }, 60000L, 10000L);
        this.updateButtons();
    }

    @Override
    protected String getTitle() {
        return Translation.get("exp.wizard.webservice.login");
    }

    private void updateOnlineStatus() {
        boolean bl = this.client.isConnected();
        boolean bl2 = ConfigurationEntry.SERVER_CONNECT_CHANGE_LOGIN_ALLOWED.getValueBoolean(this.getController());
        boolean bl3 = ConfigurationEntry.SERVER_CONNECT_REMEMBER_PASSWORD_ALLOWED.getValueBoolean(this.getController());
        if (StringUtils.isNotBlank(ConfigurationEntry.SERVER_CONNECTION_URLS.getValue(this.getController()))) {
            this.serverURLLabel.setVisible(true);
            this.serverURLBox.setVisible(true);
        }
        boolean bl4 = this.idPSelectBox == null || this.idPSelectBox.getSelectedIndex() > 0 && !this.idPSelectBox.isSAMLIDPSelected();
        boolean bl5 = bl && bl4;
        this.usernameLabel.setVisible(bl5);
        this.usernameField.setVisible(bl5);
        this.passwordLabel.setVisible(bl5);
        this.passwordField.setVisible(bl5);
        this.rememberPasswordBox.setVisible(bl && bl2 && bl3 && bl5);
        this.recoverPasswordLabel.setVisible(bl && this.client.supportsRecoverPassword() && bl5);
        this.createAccountLabel.setVisible(this.client.supportsWebRegistration());
        this.connectingLabel.setVisible(!bl);
        this.workingBar.setVisible(!bl);
        if (this.getController().getOSClient().showServerInfo()) {
            this.serverLabel.setVisible(true);
            this.serverInfoLabel.getUIComponent().setVisible(true);
            this.serverInfoLabel.setText(this.client.getServerString());
        } else {
            this.serverLabel.setVisible(false);
            this.serverInfoLabel.getUIComponent().setVisible(false);
        }
        if (bl) {
            this.usernameLabel.requestFocus();
        }
        this.updateButtons();
    }

    private void openBasedirIfMinimized() {
        if (this.getController().getUIController().getMainFrame().isIconifiedOrHidden()) {
            if (!PreferencesEntry.WEBDAV_ONLY.getValueBoolean(this.getController()).booleanValue()) {
                this.getController().getUIController().getApplicationModel().openExplorer();
            } else {
                this.getController().getUIController().getApplicationModel().openExplorerWebDAVPath();
            }
        }
    }

    private boolean isShibbolethIDPMissing() {
        if (!ConfigurationEntry.SERVER_IDP_DISCO_FEED_URL.hasNonBlankValue(this.getController())) {
            return false;
        }
        return !ConfigurationEntry.SERVER_IDP_LAST_CONNECTED_ECP.hasNonBlankValue(this.getController());
    }

    private JDialog getWizardDialog() {
        return (JDialog)this.getWizardContext().getAttribute("dialog");
    }

    private class LoginTask
    implements Runnable {
        private LoginTask() {
        }

        @Override
        public void run() {
            try {
                if (!LoginPanel.this.client.isConnected()) {
                    LOG.log(Level.WARNING, "Unable to connect");
                    throw new SecurityException(Translation.get("wizard.webservice.connect_failed"));
                }
                boolean bl = false;
                String string = LoginPanel.this.usernameField.getText();
                char[] cArray = LoginPanel.this.passwordField.getPassword();
                boolean bl2 = Arrays.equals(LoginPanel.TOKEN_PLACEHOLDER.toCharArray(), cArray) && string != null && string.equals(LoginPanel.this.client.getUsername());
                bl = bl2 ? LoginPanel.this.client.login(string, LoginPanel.this.client.getDeviceToken()).isValid() : LoginPanel.this.client.login(string, cArray).isValid();
                LoginUtil.clear(cArray);
                if (!bl) {
                    if (LoginPanel.this.isShibbolethIDPMissing()) {
                        JDialog jDialog = LoginPanel.this.getWizardDialog();
                        jDialog.setVisible(false);
                        jDialog.dispose();
                        PFWizard.openLoginWizard(LoginPanel.this.getController(), LoginPanel.this.client);
                        return;
                    }
                    throw new SecurityException(Translation.get("online_storage.account_data"));
                }
                if (LoginPanel.this.getController().isFirstStart()) {
                    LoginPanel.this.openBasedirIfMinimized();
                }
            }
            catch (SecurityException securityException) {
                LOG.log(Level.SEVERE, "Problem logging in: " + securityException.getMessage());
                throw securityException;
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Problem logging in: " + exception, exception);
                throw new SecurityException(exception.getMessage() == null ? exception.toString() : exception.getMessage());
            }
        }
    }

    private class ServerSelectAction
    implements ActionListener {
        private ServerSelectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            String string2 = ConfigurationEntry.SERVER_CONNECTION_URLS.getValue(LoginPanel.this.getController());
            int n2 = string2.indexOf(";", n = string2.indexOf(string) + string.length() + 1);
            if (n2 == -1) {
                n2 = string2.length();
            }
            String string3 = string2.substring(n, n2);
            LoginPanel.this.getController().getIOProvider().startIO(() -> LoginPanel.this.client.loadConfigURL(string3));
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            LoginPanel.this.updateButtons();
        }
    }

    private class MyServerClientListner
    implements ServerClientListener {
        private MyServerClientListner() {
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            if (LoginPanel.this.idPSelectBox != null && LoginPanel.this.idPSelectBox.isBrowserLoginOpened()) {
                JDialog jDialog = LoginPanel.this.getWizardDialog();
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            LoginPanel.this.usernameField.setText(LoginPanel.this.client.getUsername());
            if (!LoginPanel.this.client.isPasswordEmpty()) {
                LoginPanel.this.passwordField.setText(LoginPanel.this.client.getPasswordClearText());
            } else if (LoginPanel.this.client.isTokenLogin() && !Token.isExpired(LoginPanel.this.client.getDeviceToken())) {
                LoginPanel.this.passwordField.setText(LoginPanel.TOKEN_PLACEHOLDER);
            }
            LoginPanel.this.updateOnlineStatus();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            LoginPanel.this.updateOnlineStatus();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            LoginPanel.this.updateOnlineStatus();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

