/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import jwf.WizardPanel;

public class ChooseDiskLocationPanel
extends PFWizardPanel {
    private WizardPanel next;
    private final String initialLocation;
    private ValueModel locationModel;
    private JTextField locationTF;
    private JCheckBox backupByOnlineStorageBox;
    private JCheckBox manualSyncCheckBox;
    private JCheckBox sendInviteAfterCB;
    private JComponent locationField;
    private JLabel folderSizeLabel;

    public ChooseDiskLocationPanel(Controller controller, String string, WizardPanel wizardPanel) {
        super(controller);
        Reject.ifNull(wizardPanel, "Next wizard panel is null");
        this.initialLocation = string;
        this.next = wizardPanel;
    }

    @Override
    public WizardPanel next() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        return this.locationModel.getValue() != null && !StringUtils.isBlank(this.locationModel.getValue().toString());
    }

    @Override
    public boolean validateNext() {
        Path path = Paths.get((String)this.locationModel.getValue(), new String[0]);
        if (!this.validDirectory(path)) {
            return false;
        }
        this.getWizardContext().setAttribute("disklocation.localbase", path);
        this.getWizardContext().setAttribute("folder_create.backup_by_os", this.backupByOnlineStorageBox.isSelected());
        this.getWizardContext().setAttribute("disklocation.send_invitations", this.sendInviteAfterCB.isSelected());
        this.getWizardContext().setAttribute("disklocation.initial_folder_name", PathUtils.getSuggestedFolderName(path));
        if (this.manualSyncCheckBox.isSelected()) {
            this.getWizardContext().setAttribute("disklocation.sync_profile", SyncProfile.MANUAL_SYNCHRONIZATION);
        }
        return true;
    }

    @Override
    protected JPanel buildContent() {
        FolderPermission folderPermission;
        boolean bl;
        boolean bl2;
        String string = "3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
        FormLayout formLayout = new FormLayout("pref, 0:grow", string);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        String string2 = (String)this.getWizardContext().getAttribute("disklocation.prompt_text");
        if (string2 == null) {
            string2 = Translation.get("exp.wizard.choose_disk_location.select");
        }
        int n = 2;
        panelBuilder.addLabel(string2, cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.locationField, cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.folderSizeLabel, cellConstraints.xy(1, n += 2));
        FolderInfo folderInfo = (FolderInfo)this.getWizardContext().getAttribute("disklocation.folder_info");
        boolean bl3 = bl2 = folderInfo != null && this.getController().getOSClient().joinedByServer(folderInfo);
        if (this.getController().getOSClient().isBackupByDefault() && PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue() && !bl2) {
            panelBuilder.add((Component)this.backupByOnlineStorageBox, cellConstraints.xy(1, n += 2));
        }
        boolean bl4 = bl = (folderPermission = (FolderPermission)this.getWizardContext().getAttribute("folder_permission")) == null || folderPermission.getMode().equals((Object)AccessMode.ADMIN) || folderPermission.getMode().equals((Object)AccessMode.OWNER);
        if (this.getController().isBackupOnly() || !ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue() || !bl) {
            this.sendInviteAfterCB.setSelected(false);
        } else {
            panelBuilder.add((Component)this.sendInviteAfterCB, cellConstraints.xy(1, n += 2));
        }
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
        Folder folder;
        FolderInfo folderInfo = (FolderInfo)this.getWizardContext().getAttribute("disklocation.folder_info");
        String string = folderInfo == null ? this.getController().getFolderRepository().getFoldersBasedirString() : ((folder = folderInfo.getFolder(this.getController())) == null ? this.getController().getFolderRepository().getFoldersBasedirString() : folder.getLocalBase().toAbsolutePath().toString());
        this.locationModel = new ValueHolder(string);
        if (this.initialLocation != null) {
            this.locationModel.setValue(this.initialLocation);
        }
        this.locationModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChooseDiskLocationPanel.this.updateLocationComponents();
                ChooseDiskLocationPanel.this.updateButtons();
                ChooseDiskLocationPanel.this.startFolderSizeCalculator();
            }
        });
        this.locationField = this.createLocationField();
        this.locationField.setBackground(Color.WHITE);
        this.folderSizeLabel = new JLabel();
        this.startFolderSizeCalculator();
        boolean bl = this.getController().getOSClient().isBackupByDefault() && Boolean.TRUE.equals(this.getWizardContext().getAttribute("folder_create.backup_by_os"));
        this.backupByOnlineStorageBox = new JCheckBox(Translation.get("exp.wizard.choose_disk_location.backup_by_online_storage"));
        if (bl) {
            this.backupByOnlineStorageBox.setSelected(true);
        }
        this.backupByOnlineStorageBox.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (ChooseDiskLocationPanel.this.backupByOnlineStorageBox.isSelected()) {
                    ChooseDiskLocationPanel.this.getController().getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
                }
            }
        });
        this.backupByOnlineStorageBox.setOpaque(false);
        this.backupByOnlineStorageBox.setVisible(ConfigurationEntry.SERVER_SYNC_MANDATORY.getValueBoolean(this.getController()) == false);
        this.manualSyncCheckBox = new JCheckBox(Translation.get("exp.wizard.choose_disk_location.maual_sync"));
        this.manualSyncCheckBox.setOpaque(false);
        boolean bl2 = Boolean.TRUE.equals(this.getWizardContext().getAttribute("disklocation.send_invitations"));
        this.sendInviteAfterCB = SimpleComponentFactory.createCheckBox(Translation.get("exp.wizard.choose_disk_location.send_invitation"));
        this.sendInviteAfterCB.setOpaque(false);
        this.sendInviteAfterCB.setSelected(bl2);
    }

    private void startFolderSizeCalculator() {
        MySwingWorker mySwingWorker = new MySwingWorker((String)this.locationModel.getValue());
        mySwingWorker.execute();
    }

    @Override
    protected String getTitle() {
        return Translation.get("exp.wizard.choose_disk_location.title");
    }

    @Override
    protected void afterDisplay() {
        Object object = this.locationModel.getValue();
        if (object != null && object instanceof String) {
            try {
                Path path = Paths.get((String)object, new String[0]);
                if (Files.notExists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    this.startFolderSizeCalculator();
                }
                boolean bl = true;
                if (Files.notExists(path, new LinkOption[0])) {
                    bl = false;
                } else if (!Files.isWritable(path)) {
                    bl = false;
                }
                if (!bl) {
                    String string = this.getController().getFolderRepository().getFoldersBasedirString();
                    String string2 = path.getFileName().toString();
                    if (string2.length() == 0) {
                        string2 = "new";
                    }
                    Path path2 = Paths.get(string, string2);
                    int n = 1;
                    while (Files.exists(path2, new LinkOption[0])) {
                        path2 = Paths.get(string, string2 + "-" + n++);
                    }
                    Files.createDirectories(path2, new FileAttribute[0]);
                    this.startFolderSizeCalculator();
                    this.locationModel.setValue(path2.toAbsolutePath().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateLocationComponents() {
        String string = (String)this.locationModel.getValue();
        this.locationTF.setText(string);
    }

    private JComponent createLocationField() {
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.locationTF = new JTextField();
        this.locationTF.setEditable(false);
        this.locationTF.setText((String)this.locationModel.getValue());
        panelBuilder.add((Component)this.locationTF, cellConstraints.xy(1, 1));
        JButtonMini jButtonMini = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("exp.wizard.choose_disk_location.select_directory"));
        jButtonMini.addActionListener(new MyActionListener());
        panelBuilder.add((Component)jButtonMini, cellConstraints.xy(3, 1));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void displayChooseDirectory() {
        String string = (String)this.locationModel.getValue();
        List<Path> list = DialogFactory.chooseDirectory(this.getController().getUIController(), string, false);
        if (!list.isEmpty()) {
            Path path = list.get(0);
            if (!this.validDirectory(path)) {
                return;
            }
            this.locationModel.setValue(path.toAbsolutePath().toString());
        }
    }

    private boolean validDirectory(Path path) {
        if (path.equals(this.getController().getFolderRepository().getFoldersBasedir())) {
            String string = Translation.get("general.directory");
            String string2 = Translation.get("general.basedir_error.text");
            DialogFactory.genericDialog(this.getController(), string, string2, GenericDialogType.ERROR);
            return false;
        }
        if (ConfigurationEntry.FOLDER_CREATE_IN_BASEDIR_ONLY.getValueBoolean(this.getController()).booleanValue() && !path.getParent().equals(this.getController().getFolderRepository().getFoldersBasedir())) {
            String string = Translation.get("general.directory");
            String string3 = Translation.get("general.outside_basedir_error.text", this.getController().getFolderRepository().getFoldersBasedirString());
            DialogFactory.genericDialog(this.getController(), string, string3, GenericDialogType.ERROR);
            return false;
        }
        return true;
    }

    private class MySwingWorker
    extends SwingWorker<Object, Object> {
        private final String initial;
        private long directorySize;
        private boolean nonExistent;
        private boolean noWrite;
        private boolean checkNoWrite = true;

        private MySwingWorker(String string) {
            this.initial = string;
        }

        @Override
        protected Object doInBackground() throws Exception {
            ChooseDiskLocationPanel.this.folderSizeLabel.setText(Translation.get("exp.wizard.choose_disk_location.calculating_directory_size"));
            ChooseDiskLocationPanel.this.folderSizeLabel.setForeground(SystemColor.textText);
            try {
                Path path = Paths.get(this.initial, new String[0]);
                if (Files.notExists(path, new LinkOption[0])) {
                    this.nonExistent = true;
                } else if (this.checkNoWrite && !this.canWriteDirectory(path)) {
                    this.noWrite = true;
                } else {
                    this.directorySize = PathUtils.calculateDirectorySizeAndCount(path)[0];
                }
            }
            catch (Exception exception) {
                Logger.getAnonymousLogger().log(Level.WARNING, exception.toString(), exception);
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                if (this.initial.equals(ChooseDiskLocationPanel.this.locationModel.getValue())) {
                    if (this.nonExistent) {
                        ChooseDiskLocationPanel.this.folderSizeLabel.setText(Translation.get("exp.wizard.choose_disk_location.directory_non_existent"));
                        ChooseDiskLocationPanel.this.folderSizeLabel.setForeground(Color.red);
                    } else if (this.noWrite) {
                        ChooseDiskLocationPanel.this.folderSizeLabel.setText(Translation.get("exp.wizard.choose_disk_location.directory_no_write"));
                        ChooseDiskLocationPanel.this.folderSizeLabel.setForeground(Color.red);
                    } else if (PreferencesEntry.EXPERT_MODE.getValueBoolean(ChooseDiskLocationPanel.this.getController()).booleanValue()) {
                        ChooseDiskLocationPanel.this.folderSizeLabel.setText(Translation.get("exp.wizard.choose_disk_location.directory_size", Format.formatBytes(this.directorySize)));
                        ChooseDiskLocationPanel.this.folderSizeLabel.setForeground(SystemColor.textText);
                    } else {
                        ChooseDiskLocationPanel.this.folderSizeLabel.setText("");
                        ChooseDiskLocationPanel.this.folderSizeLabel.setForeground(SystemColor.textText);
                    }
                }
            }
            catch (Exception exception) {
                Logger.getAnonymousLogger().log(Level.WARNING, exception.toString(), exception);
            }
        }

        private boolean canWriteDirectory(Path path) {
            Path path2;
            while (Files.exists(path2 = path.resolve(PathUtils.removeInvalidFilenameChars(IdGenerator.makeId())), new LinkOption[0])) {
            }
            try {
                Files.createFile(path2, new FileAttribute[0]);
                boolean bl = Files.isWritable(path2);
                Files.delete(path2);
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChooseDiskLocationPanel.this.displayChooseDirectory();
        }
    }
}

