/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileSelectorFactory {
    private FileSelectorFactory() {
    }

    public static JComponent createFileSelectionField(final String string, final ValueModel valueModel, final int n, final FileFilter fileFilter, final boolean bl) {
        if (valueModel == null) {
            throw new NullPointerException("Filebase value model is null");
        }
        if (valueModel.getValue() != null && !(valueModel.getValue() instanceof String)) {
            throw new IllegalArgumentException("Value of fileselection is not of type String");
        }
        FormLayout formLayout = new FormLayout("122dlu, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        final JTextField jTextField = BasicComponentFactory.createTextField(valueModel, false);
        jTextField.setEditable(false);
        Dimension dimension = jTextField.getPreferredSize();
        dimension.width = Sizes.dialogUnitXAsPixel(30, jTextField);
        jTextField.setPreferredSize(dimension);
        final JButtonMini jButtonMini = new JButtonMini(Icons.getIconById("directory.icon"), Translation.get("folder_create.dialog.select_directory.text"));
        jButtonMini.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = null;
                if (valueModel.getValue() != null) {
                    file = new File((String)valueModel.getValue());
                }
                JFileChooser jFileChooser = DialogFactory.createFileChooser();
                jFileChooser.setFileSelectionMode(n);
                if (file != null) {
                    jFileChooser.setSelectedFile(file);
                    jFileChooser.setCurrentDirectory(file);
                }
                jFileChooser.setDialogTitle(string);
                jFileChooser.setFileSelectionMode(n);
                if (fileFilter != null) {
                    jFileChooser.setFileFilter(fileFilter);
                }
                int n2 = bl ? jFileChooser.showOpenDialog(jButtonMini) : jFileChooser.showSaveDialog(jButtonMini);
                File file2 = jFileChooser.getSelectedFile();
                if (n2 == 0 && file2 != null) {
                    valueModel.setValue(file2.getAbsolutePath());
                }
            }
        });
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jTextField, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jButtonMini, cellConstraints.xy(3, 1));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                jTextField.setEnabled(bl);
                jButtonMini.setEnabled(bl);
            }
        });
        return jPanel;
    }
}

