/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.BaseDialog;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.preferences.AdvancedSettingsTab;
import de.dal33t.powerfolder.ui.preferences.DynDnsSettingsTab;
import de.dal33t.powerfolder.ui.preferences.ExpertSettingsTab;
import de.dal33t.powerfolder.ui.preferences.GeneralSettingsTab;
import de.dal33t.powerfolder.ui.preferences.InformationTab;
import de.dal33t.powerfolder.ui.preferences.NetworkSettingsTab;
import de.dal33t.powerfolder.ui.preferences.PluginSettingsTab;
import de.dal33t.powerfolder.ui.preferences.PreferenceTab;
import de.dal33t.powerfolder.ui.preferences.WarningsNotificationsSettingsTab;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencesDialog
extends BaseDialog {
    private ValueModel myDynDnsModel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private List<PreferenceTab> preferenceTabs = new ArrayList<PreferenceTab>();
    private JTabbedPane tabbedPane;
    private InformationTab informationTab;
    private GeneralSettingsTab generalSettingsTab;
    private AdvancedSettingsTab advancedSettingsTab;
    private NetworkSettingsTab networkSettingsTab;
    private WarningsNotificationsSettingsTab warningsNotificationsSettingsTab;
    private DynDnsSettingsTab dynDnsSettingsTab;
    private ExpertSettingsTab expertSettingsTab;
    private PluginSettingsTab pluginSettingsTab;

    public PreferencesDialog(Controller controller) {
        super(BaseDialog.Senior.NONE, controller, true);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public String getTitle() {
        return Translation.get("preferences.dialog.title");
    }

    @Override
    protected Icon getIcon() {
        return null;
    }

    public ValueModel getDynDnsModel() {
        return this.myDynDnsModel;
    }

    void enableTab(int n, boolean bl) {
        this.tabbedPane.setEnabledAt(n, bl);
    }

    void selectTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    @Override
    public JComponent getContent() {
        this.initComponents();
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            return this.tabbedPane;
        }
        this.generalSettingsTab.getUIPanel().setBorder(Borders.createEmptyBorder("14dlu, 14dlu, 14dlu, 14dlu"));
        return this.generalSettingsTab.getUIPanel();
    }

    public void initComponents() {
        this.preferenceTabs.clear();
        this.myDynDnsModel = new ValueHolder(ConfigurationEntry.HOSTNAME.getValue(this.getController()));
        this.tabbedPane = new JTabbedPane(1, 0);
        this.generalSettingsTab = new GeneralSettingsTab(this.getController());
        this.preferenceTabs.add(this.generalSettingsTab);
        this.tabbedPane.addTab(this.generalSettingsTab.getTabName(), this.generalSettingsTab.getUIPanel());
        this.advancedSettingsTab = new AdvancedSettingsTab(this.getController());
        this.preferenceTabs.add(this.advancedSettingsTab);
        this.tabbedPane.addTab(this.advancedSettingsTab.getTabName(), this.advancedSettingsTab.getUIPanel());
        this.warningsNotificationsSettingsTab = new WarningsNotificationsSettingsTab(this.getController());
        this.preferenceTabs.add(this.warningsNotificationsSettingsTab);
        this.tabbedPane.addTab(this.warningsNotificationsSettingsTab.getTabName(), this.warningsNotificationsSettingsTab.getUIPanel());
        this.informationTab = new InformationTab(this.getController());
        this.preferenceTabs.add(this.informationTab);
        this.tabbedPane.addTab(this.informationTab.getTabName(), this.informationTab.getUIPanel());
        Boolean bl = PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController());
        if (bl.booleanValue()) {
            this.expertSettingsTab = new ExpertSettingsTab(this.getController());
            this.preferenceTabs.add(this.expertSettingsTab);
            this.tabbedPane.addTab(this.expertSettingsTab.getTabName(), this.expertSettingsTab.getUIPanel());
            this.networkSettingsTab = new NetworkSettingsTab(this.getController());
            this.preferenceTabs.add(this.networkSettingsTab);
            this.tabbedPane.addTab(this.networkSettingsTab.getTabName(), this.networkSettingsTab.getUIPanel());
            if (!this.getController().isBackupOnly()) {
                this.dynDnsSettingsTab = new DynDnsSettingsTab(this.getController(), this.myDynDnsModel);
                this.preferenceTabs.add(this.dynDnsSettingsTab);
                this.tabbedPane.addTab(this.dynDnsSettingsTab.getTabName(), this.dynDnsSettingsTab.getUIPanel());
            }
            if (this.getController().getPluginManager().countPlugins() > 0) {
                this.pluginSettingsTab = new PluginSettingsTab(this.getController(), this);
                this.preferenceTabs.add(this.pluginSettingsTab);
                this.tabbedPane.addTab(this.pluginSettingsTab.getTabName(), this.pluginSettingsTab.getUIPanel());
            }
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PreferencesDialog.this.dynDnsSettingsTab == null) {
                    return;
                }
                if (PreferencesDialog.this.tabbedPane.getSelectedComponent() == PreferencesDialog.this.dynDnsSettingsTab.getUIPanel()) {
                    PreferencesDialog.this.dynDnsSettingsTab.updateDynDnsInfo();
                }
            }
        });
        this.tabbedPane.setSelectedIndex(0);
        this.okButton = this.createOKButton();
        this.cancelButton = this.createCancelButton();
        this.helpButton = this.createHelpButton();
    }

    private JButton createHelpButton() {
        if (!Help.hasWiki(this.getController())) {
            return null;
        }
        BaseAction baseAction = new BaseAction("action_help", this.getController()){
            private static final long serialVersionUID = 100L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.helpAction();
            }
        };
        return new JButton(baseAction);
    }

    private JButton createOKButton() {
        return PreferencesDialog.createOKButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.okButton.setEnabled(false);
                SwingWorker<Boolean, Object> swingWorker = new SwingWorker<Boolean, Object>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        try {
                            boolean bl = PreferencesDialog.this.validateSettings();
                            if (!bl) {
                                return false;
                            }
                            PreferencesDialog.this.saveSettings();
                            if (PreferencesDialog.this.needsRestart()) {
                                PreferencesDialog.this.handleRestartRequest();
                            }
                            return true;
                        }
                        catch (Exception exception) {
                            PreferencesDialog.this.logSevere(exception);
                            return false;
                        }
                    }

                    @Override
                    public void done() {
                        try {
                            if (((Boolean)this.get()).booleanValue()) {
                                PreferencesDialog.this.close();
                            }
                        }
                        catch (Exception exception) {
                            PreferencesDialog.this.logSevere(exception);
                            DialogFactory.genericDialog(PreferencesDialog.this.getController(), Translation.get("preferences.dialog.save_error.title"), Translation.get("preferences.dialog.save_error.message"), GenericDialogType.ERROR);
                        }
                        finally {
                            PreferencesDialog.this.okButton.setEnabled(true);
                        }
                    }
                };
                swingWorker.execute();
            }
        });
    }

    private JButton createCancelButton() {
        return PreferencesDialog.createCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.close();
                PreferencesDialog.this.undoChanges();
            }
        });
    }

    private void handleRestartRequest() {
        int n = DialogFactory.genericDialog(this.getController(), Translation.get("preferences.dialog.restart.title"), Translation.get("preferences.dialog.restart.text"), new String[]{Translation.get("preferences.dialog.restart.restart")}, 0, GenericDialogType.INFO);
        if (n == 0) {
            this.getController().shutdownAndRequestRestart();
        }
    }

    @Override
    protected Component getButtonBar() {
        if (this.helpButton != null) {
            return ButtonBarFactory.buildCenteredBar(this.helpButton, this.okButton, this.cancelButton);
        }
        return ButtonBarFactory.buildCenteredBar(this.okButton, this.cancelButton);
    }

    @Override
    protected JButton getDefaultButton() {
        return this.okButton;
    }

    private void saveSettings() {
        for (PreferenceTab preferenceTab : this.preferenceTabs) {
            preferenceTab.save();
        }
        this.getController().saveConfig();
    }

    private void undoChanges() {
        for (PreferenceTab preferenceTab : this.preferenceTabs) {
            preferenceTab.undoChanges();
        }
    }

    private boolean validateSettings() {
        for (PreferenceTab preferenceTab : this.preferenceTabs) {
            boolean bl = preferenceTab.validate();
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean needsRestart() {
        for (PreferenceTab preferenceTab : this.preferenceTabs) {
            if (!preferenceTab.needsRestart()) continue;
            return true;
        }
        return false;
    }

    public void helpAction() {
        Component component = this.tabbedPane.getSelectedComponent();
        String string = "";
        if (this.generalSettingsTab != null && component == this.generalSettingsTab.getUIPanel()) {
            string = "General";
        } else if (this.advancedSettingsTab != null && component == this.advancedSettingsTab.getUIPanel()) {
            string = "User_Interface";
        } else if (this.networkSettingsTab != null && component == this.networkSettingsTab.getUIPanel()) {
            string = "Network";
        } else if (this.warningsNotificationsSettingsTab != null && component == this.warningsNotificationsSettingsTab.getUIPanel()) {
            string = "Dialogs";
        } else if (this.dynDnsSettingsTab != null && component == this.dynDnsSettingsTab.getUIPanel()) {
            string = "DynDNS";
        } else if (this.expertSettingsTab != null && component == this.expertSettingsTab.getUIPanel()) {
            string = "Expert";
        } else if (this.pluginSettingsTab != null && component == this.pluginSettingsTab.getUIPanel()) {
            string = "Plugins";
        } else if (this.informationTab != null && component == this.informationTab.getUIPanel()) {
            string = "Plugins";
        }
        String string2 = Help.getWikiArticleURL(this.getController(), string);
        BrowserLauncher.openURL(this.getController(), string2);
    }
}

